/*
 * Decompiled with CFR 0.152.
 */
package elfreader;

import elffile.ELFFile;
import elffile.SectionHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ElfReader {
    private ELFFile elfHeader;
    private RandomAccessFile file;
    private long offset = -1L;

    public ElfReader(RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        this.elfHeader = ELFFile.loadFromStream(randomAccessFile);
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public ELFFile getElfHeader() {
        return this.elfHeader;
    }

    public void seek(long l) {
        this.getSection(l);
        this.offset = l;
    }

    public byte getByte() {
        SectionHeader sectionHeader = this.getSection(this.offset);
        long l = sectionHeader.toFileOffset(this.offset);
        ++this.offset;
        try {
            this.file.seek(l);
            return this.file.readByte();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        SectionHeader sectionHeader = this.getSection(this.offset);
        long l = sectionHeader.toFileOffset(this.offset);
        this.offset += (long)n;
        try {
            this.file.seek(l);
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.file.readByte();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return byArray;
    }

    private SectionHeader getSection(long l) {
        for (SectionHeader sectionHeader : this.elfHeader.getSectionHeaders()) {
            if (!sectionHeader.isInSection(l)) continue;
            return sectionHeader;
        }
        assert (false);
        return null;
    }

    private int readE32Word() throws IOException {
        SectionHeader sectionHeader = this.getSection(this.offset);
        long l = sectionHeader.toFileOffset(this.offset);
        this.file.seek(l);
        int n = this.read() & 0xFF;
        int n2 = this.read() & 0xFF;
        int n3 = this.read() & 0xFF;
        int n4 = this.read() & 0xFF;
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    private int read() throws IOException {
        ++this.offset;
        return this.file.read();
    }

    public int getInt() {
        try {
            return this.readE32Word();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public boolean isText(long l) {
        throw new RuntimeException("Not yet implemented");
    }

    public String readString() {
        byte by;
        String string = "";
        while ((by = this.getByte()) != 0) {
            string = string + (char)by;
        }
        return string;
    }
}

