/*
 * Decompiled with CFR 0.152.
 */
package elfreader;

import elffile.ELFStreamReader;
import elffile.SectionHeader;
import elfreader.ElfReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ElfRelocationReader {
    public static Map<Long, String> getFuncNames(ElfReader elfReader) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        for (SectionHeader sectionHeader : elfReader.getElfHeader().getSectionHeaders()) {
            ElfRelocationReader.getFunctions(sectionHeader, elfReader, hashMap);
        }
        return hashMap;
    }

    private static void getFunctions(SectionHeader sectionHeader, ElfReader elfReader, HashMap<Long, String> hashMap) {
        if (sectionHeader.getType() != 9) {
            return;
        }
        ELFStreamReader eLFStreamReader = new ELFStreamReader(elfReader.getFile());
        try {
            SectionHeader sectionHeader2 = elfReader.getElfHeader().getSection(".dynsym");
            SectionHeader sectionHeader3 = elfReader.getElfHeader().getSection(".dynstr");
            assert (sectionHeader.size() % 8 == 0);
            for (int i = 0; i < sectionHeader.size(); i += 8) {
                eLFStreamReader.seek(sectionHeader.offset() + i);
                ElfRelocationReader.readEntry(eLFStreamReader, elfReader, sectionHeader2.getOffset(), sectionHeader3.getOffset(), hashMap);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void readEntry(ELFStreamReader eLFStreamReader, ElfReader elfReader, int n, int n2, HashMap<Long, String> hashMap) throws IOException {
        long l = eLFStreamReader.readE32Off();
        long l2 = eLFStreamReader.readE32Off();
        int n3 = (int)(l2 >> 8);
        eLFStreamReader.seek(n + 16 * n3);
        long l3 = eLFStreamReader.readE32Word();
        elfReader.seek(l);
        long l4 = elfReader.getInt() - 6;
        String string = eLFStreamReader.readString((int)((long)n2 + l3));
        hashMap.put(l4, string);
    }
}

