/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import org.jgrapht.DirectedGraph;

public class DominanceFrontier<V, E> {
    private DirectedGraph<V, E> g;
    private HashMap<V, V> idom;
    private HashMap<V, HashSet<V>> df = new HashMap();

    public DominanceFrontier(DirectedGraph<V, E> directedGraph, HashMap<V, V> hashMap) {
        this.g = directedGraph;
        this.idom = hashMap;
    }

    public void calc() {
        for (Object e : this.g.vertexSet()) {
            this.df.put(e, new HashSet());
        }
        for (Object e : this.g.vertexSet()) {
            if (this.g.inDegreeOf(e) <= 1) continue;
            for (Object e2 : this.g.incomingEdgesOf(e)) {
                Object object = this.g.getEdgeSource(e2);
                while (object != this.idom.get(e)) {
                    this.df.get(object).add(e);
                    object = this.idom.get(object);
                }
            }
        }
    }

    public HashMap<V, HashSet<V>> getDf() {
        return this.df;
    }

    public void dump(PrintStream printStream) {
        printStream.println("Dominance Frontier");
        for (Object e : this.g.vertexSet()) {
            printStream.print(e);
            printStream.print(":");
            for (V v : this.df.get(e)) {
                printStream.print(" ");
                printStream.print(v);
            }
            printStream.println();
        }
    }
}

