/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Edge;
import graph.SimpleEdge;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;

public class Dominator<V, E>
implements DirectedGraph<V, Edge<V>> {
    private HashMap<V, V> dom = new HashMap();
    private HashMap<V, Integer> lvl = new HashMap();
    private DirectedGraph<V, E> g;

    public Dominator(DirectedGraph<V, E> directedGraph) {
        this.g = directedGraph;
    }

    public HashMap<V, V> getDom() {
        return this.dom;
    }

    public V getEntry(Set<V> set) {
        V v = null;
        for (V v2 : set) {
            if (this.g.inDegreeOf(v2) != 0) continue;
            if (v != null) {
                new RuntimeException("Only graphs with one entry point allowed");
            }
            v = v2;
        }
        if (v == null) {
            new RuntimeException("Entry point of graph not found");
        }
        return v;
    }

    public List<V> reversePostorder() {
        HashSet hashSet = new HashSet(this.g.vertexSet());
        LinkedList linkedList = new LinkedList();
        int n = hashSet.size();
        this.revpost(this.getEntry(hashSet), linkedList, hashSet);
        assert (hashSet.isEmpty());
        assert (linkedList.size() == n);
        return linkedList;
    }

    private void revpost(V v, LinkedList<V> linkedList, Set<V> set) {
        if (!set.contains(v)) {
            return;
        }
        set.remove(v);
        for (Object e : this.g.outgoingEdgesOf(v)) {
            this.revpost(this.g.getEdgeTarget(e), linkedList, set);
        }
        linkedList.push(v);
    }

    public void calc() {
        Object object2;
        for (Object object2 : this.g.vertexSet()) {
            this.dom.put(object2, null);
            this.lvl.put((Integer)object2, -1);
        }
        Iterator<Object> iterator = this.getEntry(this.g.vertexSet());
        this.dom.put(iterator, iterator);
        this.lvl.put((Integer)((Object)iterator), 0);
        object2 = this.reversePostorder();
        boolean bl = true;
        while (bl) {
            bl = false;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (e == iterator) continue;
                Set set = this.procPred(e);
                Object e2 = set.iterator().next();
                for (Object e3 : set) {
                    if (this.dom.get(e3) == null) continue;
                    e2 = this.intersect(e3, e2);
                }
                if (this.dom.get(e) == e2) continue;
                this.dom.put(e, e2);
                this.lvl.put((Integer)e, this.lvl.get(e2) + 1);
                bl = true;
            }
        }
        this.dom.put(iterator, null);
    }

    private V intersect(V v, V v2) {
        assert (this.lvl.get(v) >= 0);
        assert (this.lvl.get(v2) >= 0);
        while (v != v2) {
            assert (this.lvl.get(v) >= 0);
            assert (this.lvl.get(v2) >= 0);
            while (this.lvl.get(v) >= this.lvl.get(v2) && v != v2) {
                v = this.dom.get(v);
                assert (this.lvl.get(v) >= 0);
            }
            while (this.lvl.get(v2) >= this.lvl.get(v) && v != v2) {
                v2 = this.dom.get(v2);
                assert (this.lvl.get(v2) >= 0);
            }
        }
        return v;
    }

    private Set<V> procPred(V v) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object e : this.g.incomingEdgesOf(v)) {
            Object object = this.g.getEdgeSource(e);
            if (this.dom.get(object) == null) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    public Edge<V> addEdge(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean addEdge(V v, V v2, Edge<V> edge) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean addVertex(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean containsEdge(Edge<V> edge) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean containsEdge(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean containsVertex(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<Edge<V>> edgeSet() {
        HashSet<Edge<V>> hashSet = new HashSet<Edge<V>>();
        for (V v : this.dom.keySet()) {
            hashSet.add(new SimpleEdge<V>(this.dom.get(v), v));
        }
        return hashSet;
    }

    public Set<Edge<V>> edgesOf(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<Edge<V>> getAllEdges(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public Edge<V> getEdge(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public EdgeFactory<V, Edge<V>> getEdgeFactory() {
        throw new RuntimeException("Not yet implemented");
    }

    public V getEdgeSource(Edge<V> edge) {
        return edge.getSrc();
    }

    public V getEdgeTarget(Edge<V> edge) {
        return edge.getDst();
    }

    public double getEdgeWeight(Edge<V> edge) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeAllEdges(Collection<? extends Edge<V>> collection) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<Edge<V>> removeAllEdges(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeAllVertices(Collection<? extends V> collection) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeEdge(Edge<V> edge) {
        throw new RuntimeException("Not yet implemented");
    }

    public Edge<V> removeEdge(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeVertex(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<V> vertexSet() {
        return this.dom.keySet();
    }

    public int inDegreeOf(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<Edge<V>> incomingEdgesOf(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public int outDegreeOf(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<Edge<V>> outgoingEdgesOf(V v) {
        throw new RuntimeException("Not yet implemented");
    }
}

