/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.UndirectedGraph;
import util.Pair;

public class SimpleUndirected<V>
implements UndirectedGraph<V, Pair<V, V>> {
    private Set<V> vertices = new HashSet<V>();
    private Set<Pair<V, V>> edges = new HashSet<Pair<V, V>>();

    public SimpleUndirected<V> complement() {
        SimpleUndirected<V> simpleUndirected = new SimpleUndirected<V>();
        for (V v : this.vertices) {
            simpleUndirected.addVertex(v);
        }
        for (V v : this.vertices) {
            for (V v2 : this.vertices) {
                if (this.containsEdge(v2, v)) continue;
                simpleUndirected.addEdge((Object)v2, (Object)v);
            }
        }
        return simpleUndirected;
    }

    private Pair<V, V> makeEdge(V v, V v2) {
        assert (this.containsVertex(v));
        assert (this.containsVertex(v2));
        if (v.hashCode() == v2.hashCode()) assert (v.equals(v2));
        if (v.hashCode() < v2.hashCode()) {
            return new Pair<V, V>(v, v2);
        }
        return new Pair<V, V>(v2, v);
    }

    public Pair<V, V> addEdge(V v, V v2) {
        Pair<V, V> pair = this.makeEdge(v, v2);
        this.edges.add(pair);
        return pair;
    }

    public boolean addEdge(V v, V v2, Pair<V, V> pair) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean addVertex(V v) {
        if (this.vertices.contains(v)) {
            return false;
        }
        this.vertices.add(v);
        return true;
    }

    public boolean containsEdge(Pair<V, V> pair) {
        return this.edges.contains(pair);
    }

    public boolean containsEdge(V v, V v2) {
        return this.containsEdge(this.makeEdge(v, v2));
    }

    public boolean containsVertex(V v) {
        return this.vertices.contains(v);
    }

    public Set<Pair<V, V>> edgeSet() {
        return this.edges;
    }

    public Set<Pair<V, V>> edgesOf(V v) {
        HashSet<Pair<V, V>> hashSet = new HashSet<Pair<V, V>>();
        for (Pair<V, V> pair : this.edges) {
            if (!pair.getFirst().equals(v) && !pair.getSecond().equals(v)) continue;
            hashSet.add(pair);
        }
        return hashSet;
    }

    public Set<Pair<V, V>> getAllEdges(V v, V v2) {
        HashSet<Pair<V, V>> hashSet = new HashSet<Pair<V, V>>();
        Object object = this.getEdge((Object)v, (Object)v2);
        if (object != null) {
            hashSet.add((Pair<V, V>)object);
        }
        return hashSet;
    }

    public Pair<V, V> getEdge(V v, V v2) {
        Pair<V, V> pair = this.makeEdge(v, v2);
        if (this.containsEdge(pair)) {
            return pair;
        }
        return null;
    }

    public EdgeFactory<V, Pair<V, V>> getEdgeFactory() {
        throw new RuntimeException("Not yet implemented");
    }

    public V getEdgeSource(Pair<V, V> pair) {
        return pair.getFirst();
    }

    public V getEdgeTarget(Pair<V, V> pair) {
        return pair.getSecond();
    }

    public double getEdgeWeight(Pair<V, V> pair) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeAllEdges(Collection<? extends Pair<V, V>> collection) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<Pair<V, V>> removeAllEdges(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeAllVertices(Collection<? extends V> collection) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeEdge(Pair<V, V> pair) {
        throw new RuntimeException("Not yet implemented");
    }

    public Pair<V, V> removeEdge(V v, V v2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeVertex(V v) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<V> vertexSet() {
        return this.vertices;
    }

    public int degreeOf(V v) {
        throw new RuntimeException("Not yet implemented");
    }
}

