/*
 * Decompiled with CFR 0.152.
 */
package graphviz;

import graphviz.DotWriter;
import graphviz.LabelWriter;
import java.io.PrintStream;
import org.jgrapht.DirectedGraph;

public class DotHtmlWriter<V, E>
extends DotWriter<V, E> {
    private LabelWriter<V, E> vw;

    public DotHtmlWriter(LabelWriter<V, E> labelWriter, DirectedGraph<V, E> directedGraph) {
        super(directedGraph);
        this.vw = labelWriter;
    }

    @Override
    protected void writeVertex(V v, PrintStream printStream) {
        printStream.print("  ");
        printStream.print(this.getId(v) + "[ ");
        printStream.print("label=<");
        this.vw.writeVertexLabel(v, printStream);
        printStream.print("> ]; ");
        printStream.println();
    }

    @Override
    protected void writeEdge(E e, PrintStream printStream) {
        printStream.print("  ");
        printStream.print(this.getId(this.g.getEdgeSource(e)));
        printStream.print(" -> ");
        printStream.print(this.getId(this.g.getEdgeTarget(e)));
        printStream.print(" [ label=\"");
        this.vw.writeEdgeLabel(e, printStream);
        printStream.print("\" ]");
        printStream.println();
    }

    private String getId(V v) {
        return this.getId(v.hashCode());
    }

    private String getId(long l) {
        return "_" + Long.toHexString(l);
    }

    @Override
    protected String getNodeShape() {
        return "plaintext";
    }
}

