/*
 * Decompiled with CFR 0.152.
 */
package graphviz;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;

public abstract class DotWriter<V, E> {
    protected Graph<V, E> g;

    public DotWriter(Graph<V, E> graph) {
        this.g = graph;
    }

    public void write(String string) {
        try {
            PrintStream printStream = new PrintStream(string);
            this.write(printStream);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public void write(PrintStream printStream) {
        if (this.isDirected()) {
            printStream.print("digraph");
        } else {
            printStream.print("graph");
        }
        printStream.println(" {");
        printStream.println("  node [ shape=" + this.getNodeShape() + " ];");
        for (Object e : this.g.vertexSet()) {
            this.writeVertex(e, printStream);
        }
        for (Object e : this.g.edgeSet()) {
            this.writeEdge(e, printStream);
        }
        printStream.println("}");
    }

    protected boolean isDirected() {
        if (this.g instanceof DirectedGraph) {
            return true;
        }
        if (this.g instanceof UndirectedGraph) {
            return false;
        }
        throw new RuntimeException("Unknown graph type: " + this.g.getClass().getName());
    }

    protected abstract void writeEdge(E var1, PrintStream var2);

    protected abstract void writeVertex(V var1, PrintStream var2);

    protected abstract String getNodeShape();
}

