/*
 * Decompiled with CFR 0.152.
 */
package graphviz;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.Function;
import cfg.statement.Statement;
import cfg.variable.Variable;
import graphviz.LabelWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import knowledge.KnowCallDst;
import knowledge.KnowOwner;
import knowledge.KnowledgeBase;
import org.apache.commons.lang.StringEscapeUtils;

public class FullLabel
implements LabelWriter<BasicBlock, BbEdge> {
    public static final String SILVER = "#cccccc";
    public static final String ORANGE = "ORANGE";
    public static final String LIME = "#9bff9b";
    public static final String GREEN = "GREEN";
    public static final String RED = "RED";
    public static final String WHITE = "WHITE";
    public static final String COLOR_NORMAL = "WHITE";
    public static final String COLOR_FUNC = "#9bff9b";
    private String prefix;
    private String sufix;
    private boolean printDeleted;
    private KnowledgeBase kb;
    private KnowOwner ko;

    public FullLabel(String string, String string2, boolean bl, KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.ko = (KnowOwner)knowledgeBase.getEntry(KnowOwner.class);
        this.prefix = string;
        this.sufix = string2;
        this.printDeleted = bl;
    }

    @Override
    public void writeVertexLabel(BasicBlock basicBlock, PrintStream printStream) {
        boolean bl = this.ko.getBbOwner(basicBlock).getEntry() == basicBlock;
        printStream.print("<TABLE BORDER=\"1\" CELLBORDER=\"0\" CELLSPACING=\"0\" ");
        printStream.print(">");
        printStream.print("<TR>");
        printStream.print("<TD>");
        printStream.print("</TD>");
        printStream.print("<TD");
        if (bl) {
            printStream.print(" BGCOLOR=\"#9bff9b\"");
        }
        printStream.print(">");
        printStream.print(basicBlock);
        printStream.print("</TD>");
        printStream.print("</TR>");
        if (bl) {
            printStream.print("<TR>");
            printStream.print("<TD>");
            printStream.print("</TD>");
            printStream.print("<TD>");
            this.writeArguments(this.ko.getBbOwner(basicBlock).getInternParam(), printStream);
            printStream.print("</TD>");
            printStream.print("</TR>");
        }
        for (Statement statement : basicBlock.getCode()) {
            this.writeInstruction(statement, printStream);
        }
        printStream.print("</TABLE>");
    }

    private void writeArguments(ArrayList<Variable> arrayList, PrintStream printStream) {
        for (Variable variable : arrayList) {
            printStream.print(variable);
            printStream.print(" ");
        }
    }

    private void writeInstruction(Statement statement, PrintStream printStream) {
        if (!statement.isDeleted() || this.printDeleted) {
            KnowCallDst knowCallDst = (KnowCallDst)this.kb.getEntry(KnowCallDst.class);
            Set<Function> set = knowCallDst.getCallDst(statement);
            printStream.print("<TR>");
            printStream.print("<TD ALIGN=\"RIGHT\" BGCOLOR=\"#cccccc\" >");
            printStream.print(statement.getNumber());
            printStream.print("</TD>");
            printStream.print("<TD ALIGN=\"LEFT\" BGCOLOR=\"" + this.getColor(statement) + "\" ");
            if (!set.isEmpty()) {
                printStream.print("HREF=\"" + this.prefix + "." + set.iterator().next() + this.sufix + "\" ");
            }
            printStream.print(" >");
            printStream.print(StringEscapeUtils.escapeHtml((String)statement.toString()));
            printStream.print("</TD>");
            printStream.print("<TD ALIGN=\"RIGHT\">");
            printStream.print("</TD>");
            printStream.print("</TR>");
        }
    }

    private String getColor(Statement statement) {
        if (statement.isDeleted()) {
            return RED;
        }
        return "WHITE";
    }

    @Override
    public void writeEdgeLabel(BbEdge bbEdge, PrintStream printStream) {
        printStream.print(bbEdge.contentString());
    }
}

