/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import ast.Ast;
import ast.expression.ArithmeticExpr;
import ast.expression.BooleanConstant;
import ast.expression.CallExpr;
import ast.expression.CompareExpr;
import ast.expression.Expression;
import ast.expression.FunctionRef;
import ast.expression.FunctionRefLinked;
import ast.expression.FunctionRefUnlinked;
import ast.expression.IfExpr;
import ast.expression.IntConstant;
import ast.expression.NullConstExpr;
import ast.expression.StringConstant;
import ast.expression.UnaryExpression;
import ast.expression.VariablePtrDeref;
import ast.expression.VariablePtrOf;
import ast.traverser.AstExpressionTraverser;
import ast.type.Type;
import ast.variable.ArrayAccess;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import ast.variable.VariableRefUnlinked;
import java.util.Collection;
import java.util.Map;

class ExpressionTypeFinder
extends AstExpressionTraverser<Type> {
    private Map<Ast, Type> type;
    private int change = 0;

    public ExpressionTypeFinder(Map<Ast, Type> map) {
        this.type = map;
    }

    public int getChanges() {
        return this.change;
    }

    public Type setType(Ast ast, Type type) {
        assert (type != null);
        Type type2 = this.type.get(ast);
        if (type2 == null) {
            this.type.put(ast, type);
            ++this.change;
            return type;
        }
        if (type2 == type) {
            return type2;
        }
        if (type2.isSupertypeOf(type)) {
            this.type.put(ast, type);
            ++this.change;
            return type;
        }
        assert (type.isSupertypeOf(type2));
        return type2;
    }

    public Type getNarrowType(Collection<? extends Ast> collection) {
        Type type = Type.Generic;
        for (Ast ast : collection) {
            type = Type.getNarrowType(this.getType(ast), type);
        }
        return type;
    }

    public Type getType(Ast ast) {
        if (!this.type.containsKey(ast)) {
            this.type.put(ast, Type.Generic);
        }
        return this.type.get(ast);
    }

    @Override
    protected Expression visitNullConstExpr(NullConstExpr nullConstExpr, Type type) {
        assert (type == Type.Pointer);
        this.setType(nullConstExpr, Type.Pointer);
        return nullConstExpr;
    }

    @Override
    protected FunctionRef visit(FunctionRef functionRef, Type type) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected FunctionRef visitFunctionRefUnlinked(FunctionRefUnlinked functionRefUnlinked, Type type) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected FunctionRef visitFunctionRefLinked(FunctionRefLinked functionRefLinked, Type type) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Variable visit(Variable variable, Type type) {
        this.setType(variable, type);
        return variable;
    }

    @Override
    protected Expression visitArrayAccess(ArrayAccess arrayAccess, Type type) {
        this.visit(arrayAccess.getIndex(), Type.Integer);
        this.setType(arrayAccess, type);
        return arrayAccess;
    }

    @Override
    protected Expression visitVariablePtrOf(VariablePtrOf variablePtrOf, Type type) {
        assert (type.isSupertypeOf(Type.Pointer));
        this.setType(variablePtrOf, Type.Pointer);
        this.visit(variablePtrOf.getVar(), Type.Generic);
        return variablePtrOf;
    }

    @Override
    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Type type) {
        this.visit(variablePtrDeref.getExpr(), Type.Pointer);
        this.setType(variablePtrDeref, type);
        return variablePtrDeref;
    }

    @Override
    protected Expression visitCallExpr(CallExpr callExpr, Type type) {
        if (!(callExpr.getFunction() instanceof FunctionRefLinked)) {
            return callExpr;
        }
        FunctionRefLinked functionRefLinked = (FunctionRefLinked)callExpr.getFunction();
        assert (callExpr.getParam().size() == functionRefLinked.getFunc().getParam().size());
        for (int i = 0; i < callExpr.getParam().size(); ++i) {
            Type type2 = Type.getNarrowType(this.getType(callExpr.getParam().get(i)), this.getType(functionRefLinked.getFunc().getParam().get(i)));
            type2 = Type.getNarrowType(type2, functionRefLinked.getFunc().getParam().get(i).getType());
            this.visit(callExpr.getParam().get(i), type2);
            this.setType(functionRefLinked.getFunc().getParam().get(i), this.getType(callExpr.getParam().get(i)));
        }
        Type type3 = Type.getNarrowType(this.getType(callExpr), functionRefLinked.getFunc().getReturnType());
        type3 = Type.getNarrowType(type3, type);
        type3 = Type.getNarrowType(type3, this.getType(functionRefLinked.getFunc()));
        this.setType(callExpr, type3);
        this.setType(functionRefLinked.getFunc(), type3);
        return callExpr;
    }

    @Override
    protected Expression visitUnaryExpression(UnaryExpression unaryExpression, Type type) {
        switch (unaryExpression.getOp()) {
            case Neg: {
                type = Type.getNarrowType(type, Type.Number);
                type = Type.getNarrowType(type, this.getType(unaryExpression));
                this.setType(unaryExpression, type);
                this.visit(unaryExpression.getExpr(), type);
                return unaryExpression;
            }
            case Not: {
                this.setType(unaryExpression, Type.Boolean);
                this.visit(unaryExpression.getExpr(), Type.Boolean);
                return unaryExpression;
            }
        }
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Expression visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, Type type) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Expression visitVariableRefLinked(VariableRefLinked variableRefLinked, Type type) {
        Type type2 = Type.getNarrowType(this.getType(variableRefLinked), this.getType(variableRefLinked.getReference()));
        type2 = Type.getNarrowType(type2, type);
        this.setType(variableRefLinked, this.setType(variableRefLinked.getReference(), type));
        this.setType(variableRefLinked.getReference(), this.setType(variableRefLinked.getReference(), type));
        return variableRefLinked;
    }

    @Override
    protected Expression visitBooleanConstant(BooleanConstant booleanConstant, Type type) {
        assert (type.isSupertypeOf(Type.Boolean));
        this.setType(booleanConstant, Type.Boolean);
        return booleanConstant;
    }

    @Override
    protected Expression visitConstant(IntConstant intConstant, Type type) {
        switch (type) {
            case Generic: 
            case Scalar: 
            case Number: {
                if (intConstant.getValue() < 0L) {
                    this.setType(intConstant, Type.Integer);
                    break;
                }
                this.setType(intConstant, Type.Number);
                break;
            }
            case Integer: {
                this.setType(intConstant, Type.Integer);
                break;
            }
            case Pointer: {
                if (intConstant.getValue() < 0L) {
                    this.setType(intConstant, Type.Integer);
                    break;
                }
                this.setType(intConstant, Type.Pointer);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled case: " + (Object)((Object)type));
            }
        }
        return intConstant;
    }

    @Override
    protected Expression visitStringConstant(StringConstant stringConstant, Type type) {
        this.setType(stringConstant, Type.String);
        return stringConstant;
    }

    @Override
    protected Expression visitIfExpr(IfExpr ifExpr, Type type) {
        this.visit(ifExpr.getCondition(), Type.Boolean);
        Type type2 = Type.getNarrowType(this.getType(ifExpr.getLeft()), this.getType(ifExpr.getRight()));
        type2 = Type.getNarrowType(type, type2);
        type2 = Type.getNarrowType(Type.Number, type2);
        this.visit(ifExpr.getLeft(), type2);
        this.visit(ifExpr.getRight(), type2);
        Type type3 = this.getType(ifExpr.getLeft());
        Type type4 = this.getType(ifExpr.getRight());
        Type type5 = Type.getCommonType(type3, type4);
        assert (type.isSupertypeOf(type5));
        this.setType(ifExpr, type5);
        return ifExpr;
    }

    @Override
    protected Expression visitCompareExpr(CompareExpr compareExpr, Type type) {
        Type type2;
        assert (type.isSupertypeOf(Type.Boolean));
        switch (compareExpr.getOperand()) {
            case EQUAL: 
            case NOT_EQUAL: {
                type2 = Type.getNarrowType(this.getType(compareExpr.getLeft()), this.getType(compareExpr.getRight()));
                break;
            }
            case GREATER: 
            case GREATER_EQUAL: 
            case LOWER: 
            case LOWER_EQUAL: {
                type2 = Type.getNarrowType(this.getType(compareExpr.getLeft()), this.getType(compareExpr.getRight()));
                type2 = Type.getNarrowType(type2, Type.Number);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled compare op: " + (Object)((Object)compareExpr.getOperand()));
            }
        }
        super.visitCompareExpr(compareExpr, type2);
        this.setType(compareExpr, Type.Boolean);
        return compareExpr;
    }

    @Override
    protected Expression visitArithmeticExpr(ArithmeticExpr arithmeticExpr, Type type) {
        Type type2 = Type.getCommonType(this.getType(arithmeticExpr.getLeft()), this.getType(arithmeticExpr.getRight()));
        switch (arithmeticExpr.getOp()) {
            case Or: 
            case Xor: 
            case And: {
                type2 = Type.getNarrowType(Type.Scalar, type2);
                type2 = Type.getNarrowType(type, type2);
                this.visit(arithmeticExpr.getLeft(), type2);
                this.visit(arithmeticExpr.getRight(), type2);
                Type type3 = this.getType(arithmeticExpr.getLeft());
                Type type4 = this.getType(arithmeticExpr.getRight());
                Type type5 = Type.getCommonType(type3, type4);
                assert (type.isSupertypeOf(type5));
                this.setType(arithmeticExpr, type5);
                return arithmeticExpr;
            }
            case Sub: {
                type2 = Type.getNarrowType(Type.Number, type2);
                type2 = Type.getNarrowType(Type.Number, type);
                this.visit(arithmeticExpr.getLeft(), type2);
                this.visit(arithmeticExpr.getRight(), type2);
                Type type6 = this.getType(arithmeticExpr.getLeft());
                Type type7 = this.getType(arithmeticExpr.getRight());
                Type type8 = Type.getCommonType(type6, type7);
                switch (type8) {
                    case Integer: {
                        break;
                    }
                    case Pointer: {
                        type8 = Type.Integer;
                        break;
                    }
                    case Number: {
                        if (Type.Pointer != type6 && Type.Pointer != type7) break;
                        type8 = Type.Pointer;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled case: " + (Object)((Object)type8));
                    }
                }
                assert (type.isSupertypeOf(type8));
                this.setType(arithmeticExpr, type8);
                return arithmeticExpr;
            }
            case Add: {
                type2 = type == Type.Pointer ? Type.Number : Type.getNarrowType(Type.Number, type);
                this.visit(arithmeticExpr.getLeft(), type2);
                this.visit(arithmeticExpr.getRight(), type2);
                Type type9 = this.getType(arithmeticExpr.getLeft());
                Type type10 = this.getType(arithmeticExpr.getRight());
                Type type11 = Type.getCommonType(type9, type10);
                assert (Type.Number.isSupertypeOf(type11));
                if (type11 == Type.Number) {
                    if (type == Type.Pointer) {
                        if (type9 == Type.Integer) {
                            this.setType(arithmeticExpr.getRight(), Type.Pointer);
                            type10 = Type.Pointer;
                            type11 = Type.Pointer;
                        } else if (type10 == Type.Integer) {
                            this.setType(arithmeticExpr.getLeft(), Type.Pointer);
                            type9 = Type.Pointer;
                            type11 = Type.Pointer;
                        } else if (type9 == Type.Pointer) {
                            this.setType(arithmeticExpr.getRight(), Type.Integer);
                            type10 = Type.Integer;
                            type11 = Type.Pointer;
                        } else if (type10 == Type.Pointer) {
                            this.setType(arithmeticExpr.getLeft(), Type.Integer);
                            type9 = Type.Integer;
                            type11 = Type.Pointer;
                        } else if (arithmeticExpr.getLeft() instanceof IntConstant) {
                            type9 = Type.Integer;
                            type11 = Type.Pointer;
                        } else if (arithmeticExpr.getRight() instanceof IntConstant) {
                            type10 = Type.Integer;
                            type11 = Type.Pointer;
                        } else {
                            throw new RuntimeException("Unhandled case");
                        }
                        this.setType(arithmeticExpr.getLeft(), type9);
                        this.setType(arithmeticExpr.getRight(), type10);
                    } else if (Type.Number == type9 && Type.Number == type10) {
                        type11 = Type.Number;
                    } else if (Type.Pointer == type9 || Type.Pointer == type10) {
                        type11 = Type.Pointer;
                    } else if (Type.Integer == type9 || Type.Integer == type10) {
                        type11 = Type.Number;
                    } else {
                        throw new RuntimeException("Unhandled case");
                    }
                }
                assert (type.isSupertypeOf(type11));
                this.setType(arithmeticExpr, type11);
                return arithmeticExpr;
            }
            case ShiftLeft: 
            case ShiftRight: 
            case Div: {
                type2 = Type.getNarrowType(Type.Number, type2);
                this.visit(arithmeticExpr.getLeft(), Type.getNarrowType(type2, type));
                this.visit(arithmeticExpr.getRight(), Type.Integer);
                Type type12 = this.getType(arithmeticExpr.getLeft());
                Type type13 = this.getType(arithmeticExpr.getRight());
                Type type14 = Type.getCommonType(type12, type13);
                if (type14 == Type.Number) {
                    assert (Type.Integer == type13);
                    type14 = type12;
                }
                assert (type.isSupertypeOf(type14));
                this.setType(arithmeticExpr, type14);
                return arithmeticExpr;
            }
            case Mul: {
                type2 = Type.getNarrowType(Type.Integer, type2);
                this.visit(arithmeticExpr.getLeft(), type2);
                this.visit(arithmeticExpr.getRight(), type2);
                Type type15 = this.getType(arithmeticExpr.getLeft());
                Type type16 = this.getType(arithmeticExpr.getRight());
                Type type17 = Type.getCommonType(type15, type16);
                assert (Type.Integer.isSupertypeOf(type17));
                this.setType(arithmeticExpr, type17);
                return arithmeticExpr;
            }
        }
        throw new RuntimeException("Not yet implemented: " + (Object)((Object)arithmeticExpr.getOp()));
    }
}

