/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import cfg.IrElement;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.SysFunction;
import graph.SimpleEdge;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import knowledge.Callgraph;
import knowledge.KnowCallDstVisitor;
import knowledge.KnowledgeBase;
import knowledge.KnowledgeEntry;
import org.jgrapht.DirectedGraph;

public class KnowCallDst
extends KnowledgeEntry {
    private KnowledgeBase base;

    @Override
    public void init(KnowledgeBase knowledgeBase) {
        this.base = knowledgeBase;
    }

    public Set<Function> getCallDst(IrElement irElement) {
        KnowCallDstVisitor knowCallDstVisitor = new KnowCallDstVisitor();
        knowCallDstVisitor.visit(irElement, null);
        return knowCallDstVisitor.getDst();
    }

    public DirectedGraph<Function, SimpleEdge<Function>> getCallgraph() {
        HashMap<Function, Set<Function>> hashMap = new HashMap<Function, Set<Function>>();
        for (PrgFunction function : this.base.getApp().getFunctions()) {
            Set<Function> set = this.getCallDst(function);
            hashMap.put(function, set);
        }
        for (SysFunction sysFunction : this.base.getApp().getAsmfunc().getAll()) {
            hashMap.put(sysFunction, new HashSet());
        }
        for (LibFunction libFunction : this.base.getApp().getDynlib().getFunctions()) {
            hashMap.put(libFunction, new HashSet());
        }
        return new Callgraph(hashMap);
    }
}

