/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import cfg.function.Function;
import cfg.variable.VariableName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import knowledge.KnowCallDst;
import knowledge.KnowLocalKilled;
import knowledge.KnowledgeBase;
import knowledge.KnowledgeEntry;

public class KnowKilledByFunction
extends KnowledgeEntry {
    private HashMap<Function, Set<VariableName>> killed = new HashMap();
    private KnowledgeBase base;

    @Override
    public void init(KnowledgeBase knowledgeBase) {
        this.base = knowledgeBase;
    }

    private void addFunc(Function function) {
        HashMap<Function, Set<VariableName>> hashMap = new HashMap<Function, Set<VariableName>>();
        this.dfs(function, hashMap);
        this.killed.put(function, hashMap.get(function));
    }

    public Set<VariableName> getKilled(Function function) {
        if (!this.killed.containsKey(function)) {
            this.addFunc(function);
        }
        if (!this.killed.containsKey(function)) {
            throw new RuntimeException("Can not find \"killed\" entry for function: " + function);
        }
        return this.killed.get(function);
    }

    private Set<VariableName> dfs(Function function, HashMap<Function, Set<VariableName>> hashMap) {
        KnowLocalKilled knowLocalKilled = (KnowLocalKilled)this.base.getEntry(KnowLocalKilled.class);
        KnowCallDst knowCallDst = (KnowCallDst)this.base.getEntry(KnowCallDst.class);
        HashSet<VariableName> hashSet = new HashSet<VariableName>();
        hashSet.addAll(knowLocalKilled.getKills(function));
        hashMap.put(function, hashSet);
        for (Function function2 : knowCallDst.getCallDst(function)) {
            if (!hashMap.containsKey(function2)) {
                this.dfs(function2, hashMap);
                assert (hashMap.containsKey(function2));
            }
            hashSet.addAll((Collection<VariableName>)hashMap.get(function2));
        }
        hashSet.removeAll(function.getPreserves());
        return hashSet;
    }
}

