/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import cfg.Flags;
import cfg.function.Function;
import cfg.variable.VariableName;
import disassembler.diStorm3.Registers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import knowledge.KnowLocalKilledVisitor;
import knowledge.KnowledgeBase;
import knowledge.KnowledgeEntry;

public class KnowLocalKilled
extends KnowledgeEntry {
    private HashMap<Function, Set<VariableName>> killed = new HashMap();
    private KnowledgeBase base;

    @Override
    public void init(KnowledgeBase knowledgeBase) {
        this.base = knowledgeBase;
    }

    private void rebuild() {
        this.killed = new HashMap();
        KnowLocalKilledVisitor knowLocalKilledVisitor = new KnowLocalKilledVisitor(this.killed);
        knowLocalKilledVisitor.visit(this.base.getApp().getFunctions(), null);
    }

    public Set<VariableName> getKills(Function function) {
        switch (function.getIrType()) {
            case FuncLibrary: {
                return this.libKilled();
            }
            case FuncProgram: {
                if (!this.killed.containsKey(function)) {
                    this.rebuild();
                }
                if (!this.killed.containsKey(function)) {
                    throw new RuntimeException("Can not find function: " + function);
                }
                return this.killed.get(function);
            }
            case FuncSystem: {
                return new HashSet<VariableName>();
            }
        }
        throw new RuntimeException("Not yet handled function type: " + (Object)((Object)function.getIrType()));
    }

    private Set<VariableName> libKilled() {
        HashSet<VariableName> hashSet = new HashSet<VariableName>();
        for (Flags flags : Flags.values()) {
            hashSet.add(flags);
        }
        hashSet.add(Registers.EAX);
        hashSet.add(Registers.ECX);
        hashSet.add(Registers.EDX);
        hashSet.add(Registers.ST0);
        hashSet.add(Registers.ST1);
        hashSet.add(Registers.ST2);
        hashSet.add(Registers.ST3);
        hashSet.add(Registers.ST4);
        hashSet.add(Registers.ST5);
        hashSet.add(Registers.ST6);
        hashSet.add(Registers.ST7);
        hashSet.add(Registers.XMM0);
        hashSet.add(Registers.XMM1);
        hashSet.add(Registers.XMM2);
        hashSet.add(Registers.XMM3);
        hashSet.add(Registers.XMM4);
        hashSet.add(Registers.XMM5);
        hashSet.add(Registers.XMM6);
        hashSet.add(Registers.XMM7);
        hashSet.add(Registers.YMM0);
        hashSet.add(Registers.YMM1);
        hashSet.add(Registers.YMM2);
        hashSet.add(Registers.YMM3);
        hashSet.add(Registers.YMM4);
        hashSet.add(Registers.YMM5);
        hashSet.add(Registers.YMM6);
        hashSet.add(Registers.YMM7);
        return hashSet;
    }
}

