/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import cfg.statement.Statement;
import java.util.List;
import knowledge.KnowMemAccessVisitor;
import knowledge.KnowledgeBase;
import knowledge.KnowledgeEntry;
import knowledge.MemAccess;

public class KnowMemAccess
extends KnowledgeEntry {
    private KnowMemAccessVisitor cache = null;

    private void updateCache(Statement statement) {
        if (this.cache != null && this.cache.getStmt() == statement) {
            return;
        }
        this.cache = new KnowMemAccessVisitor();
        this.cache.visit(statement, null);
    }

    @Override
    public void init(KnowledgeBase knowledgeBase) {
    }

    public boolean doesDynamicRead(Statement statement) {
        this.updateCache(statement);
        return this.cache.getDynamicRead();
    }

    public boolean doesDynamicWrite(Statement statement) {
        this.updateCache(statement);
        return this.cache.getDynamicWrite();
    }

    public boolean doesRead(Statement statement) {
        return this.doesDynamicRead(statement) || !this.getStaticReads(statement).isEmpty();
    }

    public boolean doesWrite(Statement statement) {
        return this.doesDynamicWrite(statement) || !this.getStaticWrites(statement).isEmpty();
    }

    public List<MemAccess> getStaticReads(Statement statement) {
        this.updateCache(statement);
        return this.cache.getStaticReads();
    }

    public List<MemAccess> getStaticWrites(Statement statement) {
        this.updateCache(statement);
        return this.cache.getStaticWrites();
    }
}

