/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import cfg.IntConstant;
import cfg.IrItr;
import cfg.IrTraverser;
import cfg.expression.CallExpr;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.matcher.VarAndOffsetMatcher;
import cfg.statement.AssignmentStmt;
import cfg.statement.Statement;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.StackVariable;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;
import java.util.LinkedList;
import java.util.List;
import knowledge.MemAccess;

class KnowMemAccessVisitor
extends IrTraverser<Void, Boolean> {
    private boolean dynamicRead = false;
    private boolean dynamicWrite = false;
    private List<MemAccess> staticReads = new LinkedList<MemAccess>();
    private List<MemAccess> staticWrites = new LinkedList<MemAccess>();
    private Statement stmt = null;

    KnowMemAccessVisitor() {
    }

    public Statement getStmt() {
        return this.stmt;
    }

    public List<MemAccess> getStaticReads() {
        return this.staticReads;
    }

    public List<MemAccess> getStaticWrites() {
        return this.staticWrites;
    }

    public boolean getDynamicRead() {
        return this.dynamicRead;
    }

    public boolean getDynamicWrite() {
        return this.dynamicWrite;
    }

    private void accessDynamicMemory(Boolean bl) {
        assert (bl != null);
        if (bl.booleanValue()) {
            this.dynamicWrite = true;
        } else {
            this.dynamicRead = true;
        }
    }

    @Override
    protected Void visitVariablePtrOf(VariablePtrOf variablePtrOf, Boolean bl) {
        assert (!bl.booleanValue());
        switch (variablePtrOf.getExpression().getIrType()) {
            case VariableArray: {
                return (Void)this.visit(((ArrayAccess)variablePtrOf.getExpression()).getIndex(), bl);
            }
        }
        return (Void)this.visit(variablePtrOf.getExpression(), bl);
    }

    @Override
    protected Void visitVariableArrayAccess(ArrayAccess arrayAccess, Boolean bl) {
        if (arrayAccess.getIndex() instanceof IntConstant) {
            this.accessStaticMemory(arrayAccess.getBase(), ((IntConstant)arrayAccess.getIndex()).getValue() * 4L, bl);
        } else {
            this.accessDynamicMemory(bl);
        }
        return (Void)super.visitVariableArrayAccess(arrayAccess, false);
    }

    @Override
    protected Void visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Boolean bl) {
        VarAndOffsetMatcher varAndOffsetMatcher = new VarAndOffsetMatcher();
        varAndOffsetMatcher.parse(new IrItr(variablePtrDeref.getExpression()));
        if (varAndOffsetMatcher.hasError()) {
            this.accessDynamicMemory(bl);
        } else {
            this.accessStaticMemory(varAndOffsetMatcher.getVar(), varAndOffsetMatcher.getOffset(), bl);
        }
        return (Void)super.visitVariablePtrDeref(variablePtrDeref, false);
    }

    private void accessStaticMemory(Object object, long l, Boolean bl) {
        MemAccess memAccess = new MemAccess();
        memAccess.base = object;
        memAccess.offset = l;
        memAccess.size = 4L;
        assert (bl != null);
        if (bl.booleanValue()) {
            this.staticWrites.add(memAccess);
        } else {
            this.staticReads.add(memAccess);
        }
    }

    @Override
    protected Void visitStackVariable(StackVariable stackVariable, Boolean bl) {
        assert (false);
        this.accessDynamicMemory(bl);
        return (Void)super.visitStackVariable(stackVariable, bl);
    }

    @Override
    protected Void visitGlobalVariable(GlobalVariable globalVariable, Boolean bl) {
        this.accessStaticMemory(globalVariable.getSegment(), globalVariable.getAddress(), bl);
        return (Void)super.visitGlobalVariable(globalVariable, bl);
    }

    @Override
    protected Void visitCallExprLinked(CallExprLinked callExprLinked, Boolean bl) {
        return this.visitCall(callExprLinked);
    }

    @Override
    protected Void visitCallExprUnlinked(CallExprUnlinked callExprUnlinked, Boolean bl) {
        return this.visitCall(callExprUnlinked);
    }

    @Override
    protected Void visitCallExprPointer(CallExprPointer callExprPointer, Boolean bl) {
        return this.visitCall(callExprPointer);
    }

    private Void visitCall(CallExpr callExpr) {
        this.dynamicWrite = true;
        this.dynamicRead = true;
        return null;
    }

    @Override
    protected Void visitStatement(Statement statement, Boolean bl) {
        assert (bl == null);
        assert (this.stmt == null);
        this.stmt = statement;
        super.visitStatement(statement, false);
        return null;
    }

    @Override
    protected Void visitAssignmentStmt(AssignmentStmt assignmentStmt, Boolean bl) {
        assert (!bl.booleanValue());
        this.visit(assignmentStmt.getSource(), false);
        this.visit(assignmentStmt.getDestination(), true);
        return null;
    }
}

