/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import cfg.basicblock.BasicBlock;
import cfg.expression.Expression;
import cfg.function.PrgFunction;
import cfg.statement.Statement;
import cfg.variable.Variable;
import java.util.HashMap;
import knowledge.KnowOwnerVisitor;
import knowledge.KnowledgeBase;
import knowledge.KnowledgeEntry;

public class KnowOwner
extends KnowledgeEntry {
    private HashMap<Variable, Statement> varOwner = new HashMap();
    private HashMap<Expression, Statement> exprOwner = new HashMap();
    private HashMap<Statement, BasicBlock> stmtOwner = new HashMap();
    private HashMap<BasicBlock, PrgFunction> bbOwner = new HashMap();
    private KnowledgeBase base;

    @Override
    public void init(KnowledgeBase knowledgeBase) {
        this.base = knowledgeBase;
    }

    private void rebuild() {
        this.varOwner = new HashMap();
        this.exprOwner = new HashMap();
        this.stmtOwner = new HashMap();
        this.bbOwner = new HashMap();
        KnowOwnerVisitor knowOwnerVisitor = new KnowOwnerVisitor(this.varOwner, this.exprOwner, this.stmtOwner, this.bbOwner);
        knowOwnerVisitor.visit(this.base.getApp().getFunctions(), null);
    }

    public Statement getVarOwner(Variable variable) {
        if (!this.varOwner.containsKey(variable)) {
            this.rebuild();
        }
        if (!this.varOwner.containsKey(variable)) {
            throw new RuntimeException("Can not find variable owner: " + variable);
        }
        return this.varOwner.get(variable);
    }

    public Statement getExprOwner(Expression expression) {
        if (!this.exprOwner.containsKey(expression)) {
            this.rebuild();
        }
        if (!this.exprOwner.containsKey(expression)) {
            throw new RuntimeException("Can not find expression owner: " + expression);
        }
        return this.exprOwner.get(expression);
    }

    public BasicBlock getStmtOwner(Statement statement) {
        if (!this.stmtOwner.containsKey(statement)) {
            this.rebuild();
        }
        if (!this.stmtOwner.containsKey(statement)) {
            throw new RuntimeException("Can not find statement owner: " + statement);
        }
        return this.stmtOwner.get(statement);
    }

    public PrgFunction getBbOwner(BasicBlock basicBlock) {
        if (!this.bbOwner.containsKey(basicBlock)) {
            this.rebuild();
        }
        if (!this.bbOwner.containsKey(basicBlock)) {
            throw new RuntimeException("Can not find basic block owner: " + basicBlock);
        }
        return this.bbOwner.get(basicBlock);
    }
}

