/*
 * Decompiled with CFR 0.152.
 */
package knowledge;

import ast.Ast;
import ast.expression.NullExpr;
import ast.statement.AssignmentStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.traverser.NopAstStatementTraverser;
import ast.type.Type;
import java.util.Collection;
import java.util.Map;
import knowledge.ExpressionTypeFinder;

class StatementTypeFinder
extends NopAstStatementTraverser<Type> {
    public StatementTypeFinder(Map<Ast, Type> map) {
        super(new ExpressionTypeFinder(map));
    }

    public int getChanges() {
        return ((ExpressionTypeFinder)this.getExpr()).getChanges();
    }

    public void setType(Ast ast, Type type) {
        ((ExpressionTypeFinder)this.getExpr()).setType(ast, type);
    }

    public Type getNarrowType(Collection<? extends Ast> collection) {
        return ((ExpressionTypeFinder)this.getExpr()).getNarrowType(collection);
    }

    public Type getType(Ast ast) {
        return ((ExpressionTypeFinder)this.getExpr()).getType(ast);
    }

    @Override
    protected Statement visitVarDef(VarDef varDef, Type type) {
        assert (type == null);
        Type type2 = this.getType(varDef.getVariable());
        type2 = Type.getNarrowType(type2, varDef.getVariable().getType());
        this.getExpr().visit(varDef.getVariable(), type2);
        return varDef;
    }

    @Override
    protected Statement visitCallStmt(CallStmt callStmt, Type type) {
        assert (type == null);
        this.getExpr().visit(callStmt.getCall(), Type.Generic);
        return callStmt;
    }

    @Override
    protected Statement visitIfStmt(IfStmt ifStmt, Type type) {
        assert (type == null);
        this.getExpr().visit(ifStmt.getCondition(), Type.Boolean);
        if (ifStmt.getThenBranch() != null) {
            this.visit(ifStmt.getThenBranch(), null);
        }
        if (ifStmt.getElseBranch() != null) {
            this.visit(ifStmt.getElseBranch(), null);
        }
        return ifStmt;
    }

    @Override
    protected Statement visitWhileStmt(WhileStmt whileStmt, Type type) {
        assert (type == null);
        this.getExpr().visit(whileStmt.getCondition(), Type.Boolean);
        this.visit(whileStmt.getBody(), null);
        return whileStmt;
    }

    @Override
    protected Statement visitDoWhileStmt(DoWhile doWhile, Type type) {
        assert (type == null);
        this.visit(doWhile.getBody(), null);
        this.getExpr().visit(doWhile.getCondition(), Type.Boolean);
        return doWhile;
    }

    @Override
    protected Statement visitCaseStmt(CaseStmt caseStmt, Type type) {
        assert (type == null);
        this.getExpr().visit(caseStmt.getCondition(), Type.Integer);
        for (int n : caseStmt.getOption().keySet()) {
            Statement statement = caseStmt.getOption().get(n);
            statement = this.visit(statement, type);
            caseStmt.getOption().put(n, statement);
        }
        if (caseStmt.getOther() != null) {
            this.visit(caseStmt.getOther(), null);
        }
        return caseStmt;
    }

    @Override
    protected Statement visitRetStmt(RetStmt retStmt, Type type) {
        Type type2 = this.getType(retStmt.getFunction());
        assert (retStmt.getRetval() != null);
        if (retStmt.getRetval() instanceof NullExpr) {
            type2 = Type.Void;
        } else {
            this.getExpr().visit(retStmt.getRetval(), Type.Scalar);
            type2 = Type.getNarrowType(type2, this.getType(retStmt.getRetval()));
        }
        this.setType(retStmt.getFunction(), type2);
        return retStmt;
    }

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, Type type) {
        assert (type == null);
        Type type2 = this.getType(assignmentStmt);
        super.visitAssignmentStmt(assignmentStmt, type2);
        type2 = Type.getNarrowType(this.getType(assignmentStmt.getDestination()), this.getType(assignmentStmt.getSource()));
        this.setType(assignmentStmt, type2);
        return assignmentStmt;
    }
}

