/*
 * Decompiled with CFR 0.152.
 */
package main;

import cfg.Application;
import cfg.function.system.SystemFunctions;
import java.io.File;
import phases.Upcompiler;
import phases.ast.AstTranslator;
import phases.ast.ExprNormalizer;
import phases.ast.PointerReplacer;
import phases.ast.StmtNormalizer;
import phases.ast.TypeReconstruction;
import phases.ast.VariableLinker;
import phases.ast.VariableNamer;
import phases.ast.VariableReduction;
import phases.cfg.ArrayReplacer;
import phases.cfg.ConditionReplacer;
import phases.cfg.Disassembler;
import phases.cfg.FunctionRecovery;
import phases.cfg.FunctionVariableLinker;
import phases.cfg.IoFunctionReplacer;
import phases.cfg.MathReduction;
import phases.cfg.MemoryFuncReplacer;
import phases.cfg.SsaBacktranslator;
import phases.cfg.SsaReduce;
import phases.java.JavaWriter;

public class Main {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Expect exactly one binary name");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        Upcompiler upcompiler = new Upcompiler();
        Application application = new Application(file, new SystemFunctions());
        upcompiler.phase(new Disassembler(upcompiler), application);
        upcompiler.phase(new FunctionVariableLinker(upcompiler), application);
        upcompiler.phase(new ConditionReplacer(upcompiler), application);
        upcompiler.phase(new FunctionRecovery(upcompiler), application);
        upcompiler.phase(new MathReduction(upcompiler), application);
        upcompiler.phase(new SsaReduce(upcompiler), application);
        upcompiler.phase(new IoFunctionReplacer(upcompiler), application);
        upcompiler.phase(new ArrayReplacer(upcompiler), application);
        upcompiler.phase(new MemoryFuncReplacer(upcompiler), application);
        upcompiler.phase(new SsaBacktranslator(upcompiler), application);
        upcompiler.phase(new AstTranslator(upcompiler), application);
        upcompiler.phase(new VariableLinker(upcompiler), application);
        upcompiler.phase(new StmtNormalizer(upcompiler), application);
        upcompiler.phase(new TypeReconstruction(upcompiler), application);
        upcompiler.phase(new PointerReplacer(upcompiler), application);
        upcompiler.phase(new VariableReduction(upcompiler), application);
        upcompiler.phase(new ExprNormalizer(upcompiler), application);
        upcompiler.phase(new StmtNormalizer(upcompiler), application);
        upcompiler.phase(new VariableNamer(upcompiler), application);
        upcompiler.phase(new JavaWriter(upcompiler), application);
    }
}

