/*
 * Decompiled with CFR 0.152.
 */
package phases;

import cfg.Application;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.PrgFunction;
import codewriter.BbWriter;
import codewriter.CodeWriter;
import codewriter.Writer;
import graphviz.DotHtmlWriter;
import graphviz.FullLabel;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import phases.Phase;

public class Upcompiler {
    private LinkedList<Integer> nr = new LinkedList();
    private LinkedList<Long> time = new LinkedList();
    private int deepth = 0;
    private Map<Integer, Long> byNr = new HashMap<Integer, Long>();
    private Map<String, Long> byPhase = new HashMap<String, Long>();

    public void phase(Phase phase, Application application) {
        ++this.deepth;
        if (this.deepth > this.nr.size()) {
            this.nr.push(0);
            this.time.push(0L);
        }
        assert (this.deepth == this.nr.size());
        this.time.pop();
        this.time.push(System.currentTimeMillis());
        phase.process(application);
        if (this.nr.size() > this.deepth) {
            this.nr.pop();
            this.time.pop();
        }
        assert (this.deepth == this.nr.size());
        long l = System.currentTimeMillis() - this.time.peek();
        long l2 = this.byNr.containsKey(this.nr.getFirst()) ? this.byNr.get(this.nr.getFirst()) : 0L;
        this.byNr.put(this.nr.getFirst(), l2 += l);
        l2 = this.byPhase.containsKey(phase.getClass().getName()) ? this.byPhase.get(phase.getClass().getName()) : 0L;
        this.byPhase.put(phase.getClass().getName(), l2 += l);
        switch (phase.outArtefact()) {
            case SSA: {
                this.printProgramLst(application, phase.getClass().getSimpleName());
                this.printFunctionGraph(application, phase.getClass().getSimpleName());
                break;
            }
            case AST: {
                this.writeProgram(application, phase.getClass().getSimpleName());
                break;
            }
            case CODE: {
                long l3 = System.currentTimeMillis();
                this.writeTime(this.byNr, application.getFile() + ".nr.csv", l3);
                this.writeTime(this.byPhase, application.getFile() + ".phase.csv", l3);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled artefact: " + (Object)((Object)phase.outArtefact()));
            }
        }
        this.nr.push(this.nr.pop() + 1);
        --this.deepth;
    }

    private <T extends Comparable> void writeTime(Map<T, Long> map, String string, long l) {
        ArrayList<T> arrayList = new ArrayList<T>(map.keySet());
        Collections.sort(arrayList);
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string, true));
            printStream.print("id");
            for (Comparable comparable : arrayList) {
                printStream.print(",");
                printStream.print(comparable);
            }
            printStream.println();
            printStream.print(l);
            for (Comparable comparable : arrayList) {
                printStream.print(",");
                printStream.print(map.get(comparable));
            }
            printStream.println();
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private void printProgramLst(Application application, String string) {
        string = application.getFile() + this.nrName() + "." + string + ".bb";
        BbWriter.write(application.getFunctions(), string);
    }

    private void printFunctionGraph(Application application, String string) {
        String string2 = application.getFile() + this.nrName() + "." + string;
        String string3 = ".gv";
        for (PrgFunction prgFunction : application.getFunctions()) {
            DotHtmlWriter<BasicBlock, BbEdge> dotHtmlWriter = new DotHtmlWriter<BasicBlock, BbEdge>(new FullLabel(string2, string3 + ".svg", false, application.getKb()), prgFunction.getGraph());
            dotHtmlWriter.write(string2 + "." + prgFunction + string3);
        }
    }

    private void writeProgram(Application application, String string) {
        string = application.getFile() + this.nrName() + "." + string + ".code";
        CodeWriter codeWriter = new CodeWriter(null);
        try {
            PrintStream printStream = new PrintStream(string);
            Writer writer = new Writer(printStream);
            codeWriter.visit(application.getPrg(), writer);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private String nrName() {
        String string = "";
        Iterator iterator = this.nr.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            string = "." + n + string;
        }
        return string;
    }
}

