/*
 * Decompiled with CFR 0.152.
 */
package phases.ast;

import ast.PrgFunc;
import ast.VariableMerger;
import ast.statement.Statement;
import ast.traverser.AstTraverser;
import ast.traverser.AstVarDependency;
import ast.traverser.AstVariableCollector;
import ast.traverser.NopAstStatementTraverser;
import ast.traverser.VariableAccessCollector;
import ast.type.Type;
import ast.variable.Variable;
import cfg.Application;
import dataflow.livevar.LiveVarGb;
import dataflow.livevar.LiveVariableAlgo;
import graph.SimpleUndirected;
import graph.TestGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.alg.ChromaticNumber;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import util.Pair;

public class Coalescing
extends Phase {
    private int removed;

    public Coalescing(Upcompiler upcompiler) {
        super(upcompiler);
    }

    public final int getRemoved() {
        return this.removed;
    }

    @Override
    public String getDescription() {
        return "coalescing variables";
    }

    @Override
    public boolean process(Application application) {
        this.removed = 0;
        for (PrgFunc prgFunc : application.getPrg().getFunction()) {
            List<Variable> list = AstVariableCollector.process(prgFunc);
            SimpleUndirected<Variable> simpleUndirected = new SimpleUndirected<Variable>();
            for (Variable variable : list) {
                simpleUndirected.addVertex(variable);
            }
            Coalescing.addTypeRestrictions(prgFunc, simpleUndirected);
            Coalescing.addLiverangeRestrictions(prgFunc, simpleUndirected);
            Coalescing.addUnrelatedRestrictions(prgFunc, list, simpleUndirected);
            Map map = ChromaticNumber.findGreedyColoredGroups(simpleUndirected);
            HashSet<List<Variable>> object2 = new HashSet<List<Variable>>();
            for (Set set : map.values()) {
                ArrayList arrayList = new ArrayList(set);
                Collections.sort(arrayList);
                object2.add(arrayList);
            }
            this.removed += VariableMerger.merge(prgFunc, object2);
        }
        return true;
    }

    private static void addUnrelatedRestrictions(PrgFunc prgFunc, List<Variable> list, SimpleUndirected<Variable> simpleUndirected) {
        TestGraph<Variable> testGraph = AstVarDependency.process(prgFunc);
        Coalescing.transitiveClosure(testGraph);
        SimpleUndirected<Variable> simpleUndirected2 = new SimpleUndirected<Variable>();
        for (Variable object : list) {
            simpleUndirected2.addVertex(object);
        }
        for (Variable variable : list) {
            for (Variable variable2 : list) {
                if (!testGraph.containsEdge(variable, variable2)) continue;
                simpleUndirected2.addEdge((Object)variable, (Object)variable2);
            }
        }
        simpleUndirected2 = simpleUndirected2.complement();
        for (Pair pair : simpleUndirected2.edgeSet()) {
            if (((Variable)pair.getFirst()).equals(pair.getSecond())) continue;
            simpleUndirected.addEdge(pair.getFirst(), pair.getSecond());
        }
    }

    private static void addLiverangeRestrictions(PrgFunc prgFunc, SimpleUndirected<Variable> simpleUndirected) {
        Set<List<Variable>> set = Coalescing.getLiveRange(prgFunc);
        for (List<Variable> list : set) {
            for (Variable variable : list) {
                for (Variable variable2 : list) {
                    if (variable == variable2) continue;
                    simpleUndirected.addEdge((Object)variable, (Object)variable2);
                }
            }
        }
    }

    private static void addTypeRestrictions(PrgFunc prgFunc, SimpleUndirected<Variable> simpleUndirected) {
        Map<Type, Set<Variable>> map = Coalescing.getTypeBuckets(prgFunc);
        for (Type type : map.keySet()) {
            for (Type type2 : map.keySet()) {
                if (type.equals((Object)type2)) continue;
                for (Variable variable : map.get((Object)type)) {
                    for (Variable variable2 : map.get((Object)type2)) {
                        simpleUndirected.addEdge((Object)variable, (Object)variable2);
                    }
                }
            }
        }
    }

    private static void transitiveClosure(TestGraph<Variable> testGraph) {
        for (Variable variable : testGraph.vertexSet()) {
            for (Variable variable2 : testGraph.vertexSet()) {
                for (Variable variable3 : testGraph.vertexSet()) {
                    if (!testGraph.containsEdge(variable2, variable) || !testGraph.containsEdge(variable, variable3)) continue;
                    testGraph.addEdge((Object)variable2, (Object)variable3);
                }
            }
        }
    }

    private static Map<Type, Set<Variable>> getTypeBuckets(PrgFunc prgFunc) {
        HashMap<Type, Set<Variable>> hashMap = new HashMap<Type, Set<Variable>>();
        VariableAccessCollector variableAccessCollector = new VariableAccessCollector();
        AstTraverser<Void> astTraverser = new AstTraverser<Void>(new NopAstStatementTraverser<Void>(variableAccessCollector));
        astTraverser.visit(prgFunc, null);
        HashSet<Variable> hashSet = new HashSet<Variable>(variableAccessCollector.getDefined());
        for (Variable variable : hashSet) {
            Set<Variable> set;
            if (variable.getSize() > 1) continue;
            if (hashMap.containsKey((Object)variable.getType())) {
                set = (Set)hashMap.get((Object)variable.getType());
            } else {
                set = new HashSet();
                hashMap.put(variable.getType(), set);
            }
            set.add(variable);
        }
        return hashMap;
    }

    private static Set<List<Variable>> getLiveRange(PrgFunc prgFunc) {
        LiveVarGb liveVarGb = new LiveVarGb();
        liveVarGb.build(prgFunc);
        LiveVariableAlgo liveVariableAlgo = new LiveVariableAlgo(liveVarGb.getGraph());
        liveVariableAlgo.process();
        HashSet<List<Variable>> hashSet = new HashSet<List<Variable>>();
        HashMap hashMap = new HashMap();
        Map map = liveVarGb.getMapping();
        for (Statement statement : map.keySet()) {
            ArrayList arrayList = new ArrayList(liveVariableAlgo.getOut().get(map.get(statement)));
            Collections.sort(arrayList);
            hashMap.put(statement, arrayList);
            hashSet.add(arrayList);
        }
        return hashSet;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.AST;
    }
}

