/*
 * Decompiled with CFR 0.152.
 */
package phases.ast;

import ast.PrgFunc;
import ast.statement.Statement;
import ast.variable.Variable;
import cfg.Application;
import dataflow.DfVertex;
import dataflow.copyprop.CopyPropGb;
import dataflow.copyprop.CopyPropagation;
import dataflow.copyprop.CopyReplacer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import util.Pair;

public class CopyPropagator
extends Phase {
    public CopyPropagator(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "propagating copies of variables";
    }

    @Override
    public boolean process(Application application) {
        for (PrgFunc prgFunc : application.getPrg().getFunction()) {
            HashMap<Statement, Map<Variable, Variable>> hashMap;
            int n;
            do {
                CopyPropGb copyPropGb = new CopyPropGb();
                copyPropGb.build(prgFunc);
                DirectedGraph directedGraph = copyPropGb.getGraph();
                CopyPropagation copyPropagation = new CopyPropagation(directedGraph);
                copyPropagation.process();
                hashMap = new HashMap<Statement, Map<Variable, Variable>>();
                for (Statement statement : copyPropGb.getMapping().keySet()) {
                    DfVertex dfVertex = copyPropGb.getMapping().get(statement);
                    Set set = copyPropagation.getIn().get(dfVertex);
                    assert (set != null);
                    HashMap hashMap2 = new HashMap();
                    for (Pair pair : set) {
                        assert (pair.getFirst() != null);
                        assert (pair.getSecond() != null);
                        assert (!hashMap2.containsKey(pair.getFirst()));
                        hashMap2.put(pair.getFirst(), pair.getSecond());
                    }
                    hashMap.put(statement, hashMap2);
                }
            } while ((n = CopyReplacer.process(prgFunc.getBody(), hashMap)) > 0);
        }
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.AST;
    }
}

