/*
 * Decompiled with CFR 0.152.
 */
package phases.ast;

import ast.Function;
import ast.PrgFunc;
import cfg.Application;
import cfg.function.PrgFunction;
import java.util.HashMap;
import java.util.Map;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;

public class Structurer
extends Phase {
    private final Map<Long, Function> functions = new HashMap<Long, Function>();

    public Structurer(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "structuring code";
    }

    @Override
    public boolean process(Application application) {
        application.getPrg().getFunction().add(null);
        int n = 0;
        for (PrgFunction prgFunction : application.getFunctions()) {
            PrgFunc prgFunc = structuring.Structurer.process(prgFunction);
            this.functions.put(prgFunction.getAddr(), prgFunc);
            if (prgFunction.getAddr() == application.getMainAddr()) {
                prgFunc.setName("main");
                application.getPrg().getFunction().set(0, prgFunc);
                continue;
            }
            prgFunc.setName("func" + n);
            ++n;
            application.getPrg().getFunction().add(prgFunc);
        }
        return true;
    }

    public final Map<Long, Function> getFunctions() {
        return this.functions;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.AST;
    }
}

