/*
 * Decompiled with CFR 0.152.
 */
package phases.ast;

import ast.PrgFunc;
import ast.traverser.AstVariableCollector;
import ast.traverser.MissingTypeCheater;
import ast.type.Type;
import ast.variable.Variable;
import cfg.Application;
import java.util.ArrayList;
import java.util.List;
import knowledge.KnowTypes;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;

public class TypeReconstruction
extends Phase {
    public TypeReconstruction(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "find types";
    }

    @Override
    public boolean process(Application application) {
        Type type;
        KnowTypes knowTypes = (KnowTypes)application.getKb().getEntry(KnowTypes.class);
        List<Variable> list = AstVariableCollector.process(application.getPrg());
        for (Variable ast : list) {
            type = knowTypes.getTypeOf(ast);
            ast.setType(type);
        }
        for (PrgFunc prgFunc : new ArrayList<PrgFunc>(application.getPrg().getFunction())) {
            type = knowTypes.getTypeOf(prgFunc);
            prgFunc.setReturnType(type);
        }
        MissingTypeCheater.process(application.getPrg());
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.AST;
    }
}

