/*
 * Decompiled with CFR 0.152.
 */
package phases.cfg;

import cfg.Application;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import phases.cfg.SsaReduce;
import phases.cfg.VariableLinker;
import reduction.ArrayVarReplacer;
import reduction.UnlinkedPhiDeleter;

public class ArrayReplacer
extends Phase {
    public ArrayReplacer(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "replace arrays with variables";
    }

    @Override
    public boolean process(Application application) {
        SsaReduce ssaReduce;
        do {
            application.getKb().clear();
            ArrayVarReplacer.process(application, "lar");
            this.upcompiler.phase(new VariableLinker(this.upcompiler, true, false), application);
            UnlinkedPhiDeleter.process(application);
            ssaReduce = new SsaReduce(this.upcompiler);
            this.upcompiler.phase(ssaReduce, application);
        } while (ssaReduce.getRemoved() != 0);
        application.getKb().clear();
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.SSA;
    }
}

