/*
 * Decompiled with CFR 0.152.
 */
package phases.cfg;

import cfg.Application;
import cfg.parser.IntermediateFactory;
import disassembler.diStorm3.CodeInfo;
import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.DecomposedResult;
import disassembler.diStorm3.distorm3;
import elffile.SectionHeader;
import elfreader.ElfReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;

public class Disassembler
extends Phase {
    public Disassembler(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "Disassemble binary";
    }

    @Override
    public boolean process(Application application) {
        try {
            application.setElfReader(new ElfReader(new RandomAccessFile(application.getFile(), "r")));
            SectionHeader sectionHeader = application.getElfReader().getElfHeader().getSection(".text");
            int n = sectionHeader.size();
            long l = sectionHeader.addr();
            application.getElfReader().seek(l);
            byte[] byArray = application.getElfReader().getBytes(n);
            CodeInfo codeInfo = new CodeInfo(l, byArray, distorm3.DecodeType.Decode32Bits, 0);
            DecomposedResult decomposedResult = new DecomposedResult(n);
            distorm3.Decompose(codeInfo, decomposedResult);
            application.getElfReader().seek(application.getElfReader().getElfHeader().getHeader().getEntry() + 24);
            long l2 = application.getElfReader().getInt();
            IntermediateFactory intermediateFactory = new IntermediateFactory(l2, new ArrayList<DecomposedInst>(Arrays.asList(decomposedResult.mInstructions)), application.getElfReader(), application);
            intermediateFactory.process();
            application.setMainAddr(l2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.SSA;
    }
}

