/*
 * Decompiled with CFR 0.152.
 */
package phases.cfg;

import cfg.Application;
import cfg.function.PrgFunction;
import cfg.function.argument.ActualArgumentInserter;
import cfg.function.argument.ArgumentPtrReplacer;
import cfg.function.argument.EspEbpReplacer;
import cfg.function.argument.FunctionArgumentCounter;
import java.util.Set;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import phases.cfg.VariableLinker;
import reduction.PtrArrayReplacer;

public class FunctionRecovery
extends Phase {
    public FunctionRecovery(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "parameter handling, replacement of stack with arrays";
    }

    @Override
    public boolean process(Application application) {
        FunctionArgumentCounter.process(application.getFunctions());
        for (PrgFunction prgFunction : application.getFunctions()) {
            Set<Long> set = EspEbpReplacer.process(prgFunction);
            Set<Long> set2 = ActualArgumentInserter.process(prgFunction);
            set.addAll(set2);
            PtrArrayReplacer.process(prgFunction, set);
        }
        ArgumentPtrReplacer.process(application.getFunctions());
        this.upcompiler.phase(new VariableLinker(this.upcompiler, true, false), application);
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.SSA;
    }
}

