/*
 * Decompiled with CFR 0.152.
 */
package phases.cfg;

import cfg.Application;
import cfg.expression.Expression;
import cfg.statement.Statement;
import cfg.unlinker.SimpleSsaBacktranslation;
import cfg.unlinker.VariableRenamer;
import cfg.unlinker.VariableUnlinker;
import java.util.Set;
import knowledge.KnowOwner;
import knowledge.KnowUnlinked;
import knowledge.KnowledgeBase;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;

public class SsaBacktranslator
extends Phase {
    public SsaBacktranslator(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "getting out of SSA";
    }

    @Override
    public boolean process(Application application) {
        SsaBacktranslator.checkForUnlinked(application.getKb());
        VariableRenamer.rename(application.getFunctions());
        VariableUnlinker.unlink(application.getFunctions());
        SimpleSsaBacktranslation.translate(application.getFunctions());
        return true;
    }

    private static void checkForUnlinked(KnowledgeBase knowledgeBase) {
        KnowUnlinked knowUnlinked = (KnowUnlinked)knowledgeBase.getEntry(KnowUnlinked.class);
        KnowOwner knowOwner = (KnowOwner)knowledgeBase.getEntry(KnowOwner.class);
        Set<Expression> set = knowUnlinked.getUnlinked(knowledgeBase.getApp().getFunctions());
        if (!set.isEmpty()) {
            System.out.println("Unlinked found:");
            for (Expression expression : set) {
                Statement statement = knowOwner.getExprOwner(expression);
                System.out.print(knowOwner.getBbOwner(knowOwner.getStmtOwner(statement)));
                System.out.print(": ");
                System.out.print(statement);
                System.out.println();
            }
            System.out.println();
            throw new RuntimeException("Unlinked found, should not happen");
        }
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.SSA;
    }
}

