/*
 * Decompiled with CFR 0.152.
 */
package phases.cfg;

import cfg.Application;
import cfg.function.PrgFunction;
import java.util.Iterator;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.ExpressionReduction;
import reduction.MemoryModelEnforcer;
import reduction.StmtDeleter;
import reduction.UnusedVariableRemover;

public class SsaReduce
extends Phase {
    private int removed = 0;

    public SsaReduce(Upcompiler upcompiler) {
        super(upcompiler);
    }

    public final int getRemoved() {
        return this.removed;
    }

    @Override
    public String getDescription() {
        return "inlining expressions, remove dead stmts";
    }

    @Override
    public boolean process(Application application) {
        Iterator<PrgFunction> iterator = application.getFunctions().iterator();
        while (iterator.hasNext()) {
            int n;
            PrgFunction prgFunction;
            PrgFunction prgFunction2 = prgFunction = iterator.next();
            MemoryModelEnforcer memoryModelEnforcer = new MemoryModelEnforcer(application);
            do {
                application.getKb().clear();
                ExpressionReduction.reduce(prgFunction2, memoryModelEnforcer, application.getKb());
                application.getKb().clear();
                UnusedVariableRemover.process(prgFunction2, application.getKb());
                n = StmtDeleter.process(prgFunction2, application.getKb());
                this.removed += n;
            } while (n > 0);
            assert (StmtDeleter.process(prgFunction2, application.getKb()) == 0);
        }
        application.getKb().clear();
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.SSA;
    }
}

