/*
 * Decompiled with CFR 0.152.
 */
package phases.cfg;

import cfg.Application;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.PrgFunction;
import cfg.linker.InterBbVariableLinker;
import cfg.linker.IntraBbVariableLinker;
import cfg.linker.PhiInserter;
import graph.DominanceFrontier;
import graph.Dominator;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;

public class VariableLinker
extends Phase {
    private boolean linkUnlinked;
    private boolean linkKilled;

    public VariableLinker(Upcompiler upcompiler, boolean bl, boolean bl2) {
        super(upcompiler);
        this.linkUnlinked = bl;
        this.linkKilled = bl2;
    }

    @Override
    public String getDescription() {
        return "linking variables, inserting phi functions whenever needed";
    }

    @Override
    public boolean process(Application application) {
        for (PrgFunction prgFunction : application.getFunctions()) {
            Dominator<BasicBlock, BbEdge> dominator = new Dominator<BasicBlock, BbEdge>(prgFunction.getGraph());
            dominator.calc();
            DominanceFrontier<BasicBlock, BbEdge> dominanceFrontier = new DominanceFrontier<BasicBlock, BbEdge>(prgFunction.getGraph(), dominator.getDom());
            dominanceFrontier.calc();
            PhiInserter phiInserter = new PhiInserter(prgFunction, dominanceFrontier);
            phiInserter.doWork();
            IntraBbVariableLinker intraBbVariableLinker = new IntraBbVariableLinker(application.getKb(), this.linkUnlinked, this.linkKilled);
            intraBbVariableLinker.visit(prgFunction, null);
            InterBbVariableLinker.link(intraBbVariableLinker, dominator.getDom(), prgFunction, this.linkUnlinked, this.linkKilled);
        }
        return true;
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.SSA;
    }
}

