/*
 * Decompiled with CFR 0.152.
 */
package phases.java;

import ast.Ast;
import cfg.Application;
import codewriter.CodeWriter;
import codewriter.SupportWriter;
import codewriter.Writer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;

public class JavaWriter
extends Phase {
    public JavaWriter(Upcompiler upcompiler) {
        super(upcompiler);
    }

    @Override
    public String getDescription() {
        return "write java files";
    }

    @Override
    public boolean process(Application application) {
        File file = application.getFile().getAbsoluteFile();
        JavaWriter.writeProgram(file.getParent() + File.separator + application.getPrg().getOutputName() + ".java", application.getPrg());
        SupportWriter.generateFiles(file.getParent());
        return true;
    }

    private static void writeProgram(String string, Ast ast) {
        CodeWriter codeWriter = new CodeWriter(null);
        try {
            PrintStream printStream = new PrintStream(string);
            Writer writer = new Writer(printStream);
            codeWriter.visit(ast, writer);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    public ArtefactType outArtefact() {
        return ArtefactType.CODE;
    }
}

