/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Application;
import cfg.Assignable;
import cfg.IntConstant;
import cfg.IrReplaceExprTraverser;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.expression.VariableRefUnlinked;
import cfg.statement.AssignmentStmt;
import cfg.unlinker.HllVariable;
import cfg.variable.ArrayAccess;
import cfg.variable.SsaVariable;
import java.util.List;
import knowledge.KnowDynamicArrayAccess;
import knowledge.KnowledgeBase;

public class ArrayVarReplacer
extends IrReplaceExprTraverser<Void> {
    private String varPrefix;
    private KnowDynamicArrayAccess kdaa;

    public static void process(Application application, String string) {
        ArrayVarReplacer arrayVarReplacer = new ArrayVarReplacer(string, application.getKb());
        arrayVarReplacer.visitCollection(application.getFunctions(), null);
    }

    public ArrayVarReplacer(String string, KnowledgeBase knowledgeBase) {
        this.varPrefix = string;
        this.kdaa = (KnowDynamicArrayAccess)knowledgeBase.getEntry(KnowDynamicArrayAccess.class);
    }

    @Override
    protected void visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        super.visitAssignmentStmt(assignmentStmt, null);
        List<Assignable> list = assignmentStmt.getDestination();
        for (int i = 0; i < list.size(); ++i) {
            ArrayAccess arrayAccess;
            if (!(list.get(i) instanceof ArrayAccess) || this.kdaa.hasDynamicAccess((arrayAccess = (ArrayAccess)list.get(i)).getBase())) continue;
            assert (arrayAccess.getIndex().getIrType() == IrType.IntConstant);
            HllVariable hllVariable = this.createVarName(arrayAccess);
            list.set(i, new SsaVariable(hllVariable, 0));
        }
    }

    private HllVariable createVarName(ArrayAccess arrayAccess) {
        String string = this.varPrefix + "_" + arrayAccess.getBase().getName().toString() + "_" + ((IntConstant)arrayAccess.getIndex()).getValue();
        return new HllVariable(string);
    }

    @Override
    protected Expression visitVariableArray(ArrayAccess arrayAccess, Void void_) {
        if (!this.kdaa.hasDynamicAccess(arrayAccess.getBase())) {
            assert (arrayAccess.getIndex().getIrType() == IrType.IntConstant);
            HllVariable hllVariable = this.createVarName(arrayAccess);
            return new VariableRefUnlinked(hllVariable);
        }
        return super.visitVariableArray(arrayAccess, void_);
    }
}

