/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Condition;
import cfg.IntConstant;
import cfg.expression.BooleanExpr;
import cfg.expression.CompareExpr;
import cfg.expression.CompareOp;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.VariableRefLinked;
import cfg.statement.AssignmentStmt;
import cfg.statement.Statement;
import cfg.variable.Variable;
import reduction.ExprCopy;

public class ConditionParser {
    public static BooleanExpr findExpression(Condition condition, Statement statement) {
        switch (statement.getOriginal().getOpcode()) {
            case TEST: 
            case AND: {
                return ConditionParser.findExprTest(condition, (AssignmentStmt)statement);
            }
            case CMP: {
                return ConditionParser.findExprCmp(condition, (AssignmentStmt)statement);
            }
            case DEC: 
            case ADD: {
                return ConditionParser.findExprDec(condition, (AssignmentStmt)statement);
            }
        }
        throw new RuntimeException("Not yet handled opcode: " + (Object)((Object)statement.getOriginal().getOpcode()));
    }

    private static BooleanExpr findExprDec(Condition condition, AssignmentStmt assignmentStmt) {
        Variable variable = (Variable)((Object)assignmentStmt.getDestination().iterator().next());
        VariableRefLinked variableRefLinked = new VariableRefLinked(variable);
        switch (condition) {
            case NotEqualNotZero: {
                return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.NOT_EQUAL);
            }
            case EqualZero: {
                return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.EQUAL);
            }
        }
        throw new RuntimeException("Not yet handled opcode: " + (Object)((Object)condition));
    }

    private static BooleanExpr findExprCmp(Condition condition, AssignmentStmt assignmentStmt) {
        IntegerExpr integerExpr = (IntegerExpr)assignmentStmt.getSource();
        switch (condition) {
            case EqualZero: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.EQUAL);
            }
            case LessThanOrEqual: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.LOWER_EQUAL);
            }
            case BelowOrEqual: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.LOWER_EQUAL);
            }
            case LessThan: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.LOWER);
            }
            case Below: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.LOWER);
            }
            case GreaterThanOrEqual: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.GREATER_EQUAL);
            }
            case GreaterThan: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.GREATER);
            }
            case Above: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.GREATER);
            }
            case AboveOrEqual: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.GREATER_EQUAL);
            }
            case NotEqualNotZero: {
                return new CompareExpr(ExprCopy.copy(integerExpr.getLeft()), ExprCopy.copy(integerExpr.getRight()), CompareOp.NOT_EQUAL);
            }
        }
        throw new RuntimeException("Not yet handled opcode: " + (Object)((Object)condition));
    }

    private static BooleanExpr findExprTest(Condition condition, AssignmentStmt assignmentStmt) {
        IntegerExpr integerExpr = (IntegerExpr)assignmentStmt.getSource();
        Expression expression = integerExpr.getLeft();
        Expression expression2 = integerExpr.getRight();
        if (expression2 instanceof VariableRefLinked && expression instanceof VariableRefLinked && ((VariableRefLinked)expression).getReference() == ((VariableRefLinked)expression2).getReference()) {
            Variable variable = ((VariableRefLinked)expression).getReference();
            VariableRefLinked variableRefLinked = new VariableRefLinked(variable);
            switch (condition) {
                case LessThanOrEqual: {
                    return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.LOWER_EQUAL);
                }
                case NotEqualNotZero: {
                    return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.NOT_EQUAL);
                }
                case EqualZero: {
                    return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.EQUAL);
                }
                case GreaterThan: {
                    return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.GREATER);
                }
                case Sign: {
                    return new CompareExpr(variableRefLinked, new IntConstant(0L), CompareOp.LOWER);
                }
            }
            throw new RuntimeException("Not yet handled opcode: " + (Object)((Object)condition));
        }
        switch (condition) {
            case EqualZero: {
                return new CompareExpr(ExprCopy.copy(integerExpr), new IntConstant(0L), CompareOp.EQUAL);
            }
            case NotEqualNotZero: {
                return new CompareExpr(ExprCopy.copy(integerExpr), new IntConstant(0L), CompareOp.NOT_EQUAL);
            }
        }
        throw new RuntimeException("Not yet handled opcode: " + (Object)((Object)condition));
    }
}

