/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Condition;
import cfg.IrElement;
import cfg.IrStmtTraverser;
import cfg.basicblock.BasicBlock;
import cfg.expression.BooleanExpr;
import cfg.expression.CompareExpr;
import cfg.expression.IfExpr;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;
import disassembler.diStorm3.DecomposedInst;
import java.util.Set;
import knowledge.KnowLinks;
import knowledge.KnowledgeBase;
import reduction.ConditionParser;
import reduction.MemoryModelEnforcer;

public class ConditionReduction
extends IrStmtTraverser<Void, BasicBlock> {
    private KnowledgeBase kb;
    private MemoryModelEnforcer mm;

    public ConditionReduction(KnowledgeBase knowledgeBase, MemoryModelEnforcer memoryModelEnforcer) {
        this.kb = knowledgeBase;
        this.mm = memoryModelEnforcer;
    }

    @Override
    protected Void visitBasicBlock(BasicBlock basicBlock, BasicBlock basicBlock2) {
        assert (basicBlock2 == null);
        return (Void)super.visitBasicBlock(basicBlock, basicBlock);
    }

    @Override
    protected Void visitAssignmentStmt(AssignmentStmt assignmentStmt, BasicBlock basicBlock) {
        DecomposedInst decomposedInst = assignmentStmt.getOriginal();
        if (decomposedInst == null) {
            return (Void)super.visitAssignmentStmt(assignmentStmt, basicBlock);
        }
        Condition condition = Condition.parse(decomposedInst.getOpcode());
        if (condition == null) {
            return (Void)super.visitAssignmentStmt(assignmentStmt, basicBlock);
        }
        switch (assignmentStmt.getSource().getIrType()) {
            case IfExpr: {
                IfExpr ifExpr = (IfExpr)assignmentStmt.getSource();
                Statement statement = this.getReferencedStmt(ifExpr.getCondition());
                if (statement == null) break;
                if (!this.mm.isMoveAllowed(basicBlock.getCode(), statement, assignmentStmt)) {
                    throw new RuntimeException("move of statement/expression not allowed");
                }
                BooleanExpr booleanExpr = ConditionParser.findExpression(condition, statement);
                ifExpr.setCondition(booleanExpr);
                break;
            }
            case CompareExpr: {
                CompareExpr compareExpr = (CompareExpr)assignmentStmt.getSource();
                Statement statement = this.getReferencedStmt(compareExpr);
                if (statement == null) break;
                if (!this.mm.isMoveAllowed(basicBlock.getCode(), statement, assignmentStmt)) {
                    throw new RuntimeException("move of statement/expression not allowed");
                }
                BooleanExpr booleanExpr = ConditionParser.findExpression(condition, statement);
                assignmentStmt.setSource(booleanExpr);
                break;
            }
            default: {
                throw new RuntimeException("Not yet implemented: " + assignmentStmt.getSource());
            }
        }
        return null;
    }

    @Override
    protected Void visitJumpStmt(JumpStmt jumpStmt, BasicBlock basicBlock) {
        Statement statement = this.getReferencedStmt(jumpStmt);
        if (statement != null) {
            if (!this.mm.isMoveAllowed(basicBlock.getCode(), statement, jumpStmt)) {
                throw new RuntimeException("move of statement/expression not allowed");
            }
            Condition condition = Condition.parse(jumpStmt.getOriginal().getOpcode());
            if (condition != null) {
                assert (condition != null);
                BooleanExpr booleanExpr = ConditionParser.findExpression(condition, statement);
                jumpStmt.setExpression(booleanExpr);
            }
        }
        return null;
    }

    private Statement getReferencedStmt(IrElement irElement) {
        KnowLinks knowLinks = (KnowLinks)this.kb.getEntry(KnowLinks.class);
        Set<Statement> set = knowLinks.getLinks(irElement);
        switch (set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return set.iterator().next();
            }
        }
        throw new RuntimeException("Don't know how to handle multiple references: " + irElement);
    }
}

