/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Assignable;
import cfg.IrElement;
import cfg.IrReplaceExprTraverser;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.expression.Expression;
import cfg.expression.VariableRefLinked;
import cfg.statement.Assignment;
import cfg.statement.AssignmentStmt;
import cfg.statement.PhiStmt;
import cfg.statement.Statement;
import cfg.variable.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import knowledge.KnowOwner;
import knowledge.KnowReferencees;
import knowledge.KnowledgeBase;
import reduction.ExprCopy;
import reduction.InliningCostCalculator;
import reduction.MemoryModelEnforcer;

public class ExpressionReduction
extends IrReplaceExprTraverser<Void> {
    private MemoryModelEnforcer mm;
    private BasicBlock bb = null;
    private Statement stmt = null;
    private KnowledgeBase kb;

    public static void reduce(IrElement irElement, MemoryModelEnforcer memoryModelEnforcer, KnowledgeBase knowledgeBase) {
        ExpressionReduction expressionReduction = new ExpressionReduction(memoryModelEnforcer, knowledgeBase);
        expressionReduction.visit(irElement, null);
    }

    public ExpressionReduction(MemoryModelEnforcer memoryModelEnforcer, KnowledgeBase knowledgeBase) {
        this.mm = memoryModelEnforcer;
        this.kb = knowledgeBase;
    }

    @Override
    protected void visitBasicBlock(BasicBlock basicBlock, Void void_) {
        assert (this.bb == null);
        this.bb = basicBlock;
        super.visitBasicBlock(basicBlock, void_);
        this.bb = null;
    }

    @Override
    protected void visitStatement(Statement statement, Void void_) {
        assert (this.stmt == null);
        this.stmt = statement;
        super.visitStatement(statement, void_);
        this.stmt = null;
    }

    @Override
    protected Expression visitVariableRefLinked(VariableRefLinked variableRefLinked, Void void_) {
        KnowOwner knowOwner = (KnowOwner)this.kb.getEntry(KnowOwner.class);
        Statement statement = knowOwner.getVarOwner(variableRefLinked.getReference());
        assert (!knowOwner.getExprOwner(variableRefLinked).isDeleted());
        if (statement.isDeleted()) {
            throw new RuntimeException("Expression depends on deleted statement: " + knowOwner.getExprOwner(variableRefLinked));
        }
        switch (statement.getIrType()) {
            case AssignmentStmt: {
                return this.checkAssignment(variableRefLinked, statement);
            }
            case PhiStmt: {
                return this.checkPhi(variableRefLinked, statement);
            }
        }
        throw new RuntimeException("Unhandled type: " + (Object)((Object)statement.getIrType()));
    }

    private Expression checkPhi(VariableRefLinked variableRefLinked, Statement statement) {
        PhiStmt phiStmt = (PhiStmt)statement;
        if (phiStmt.getOption().isEmpty()) {
            return variableRefLinked;
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>(phiStmt.getOption().values());
        if (arrayList.get(0).getIrType() != IrType.VariableRefLinked) {
            return variableRefLinked;
        }
        VariableRefLinked variableRefLinked2 = (VariableRefLinked)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            if (arrayList.get(i).getIrType() != IrType.VariableRefLinked) {
                return variableRefLinked;
            }
            VariableRefLinked variableRefLinked3 = (VariableRefLinked)arrayList.get(i);
            if (variableRefLinked2.getReference() == variableRefLinked3.getReference()) continue;
            return variableRefLinked;
        }
        return new VariableRefLinked(variableRefLinked2.getReference());
    }

    private Expression checkAssignment(VariableRefLinked variableRefLinked, Statement statement) {
        AssignmentStmt assignmentStmt = (AssignmentStmt)statement;
        if (assignmentStmt == null || !this.mm.isMoveAllowed(this.bb.getCode(), assignmentStmt, this.stmt)) {
            return variableRefLinked;
        }
        Set<Statement> set = this.getAllReferencees(assignmentStmt);
        if (set.size() <= 0) {
            throw new RuntimeException("impossible combination, obj is referencing cmp: " + variableRefLinked + " <=> " + assignmentStmt + " :: nr " + statement.getNumber());
        }
        Expression expression = assignmentStmt.getSource();
        int n = InliningCostCalculator.getCost(expression);
        if ((n *= set.size() - 1) > 0) {
            return variableRefLinked;
        }
        return ExprCopy.copy(assignmentStmt.getSource());
    }

    private Set<Statement> getAllReferencees(Assignment assignment) {
        HashSet<Statement> hashSet = new HashSet<Statement>();
        KnowReferencees knowReferencees = (KnowReferencees)this.kb.getEntry(KnowReferencees.class);
        for (Assignable assignable : assignment.getDestination()) {
            if (assignable.getIrType() != IrType.Variable) continue;
            hashSet.addAll(knowReferencees.getReferencees((Variable)((Object)assignable)));
        }
        return hashSet;
    }
}

