/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Assignable;
import cfg.IntConstant;
import cfg.IrReplaceExprTraverser;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.function.PrgFunction;
import cfg.statement.AssignmentStmt;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;
import java.util.Collection;

public class MathExprReduction
extends IrReplaceExprTraverser<Void> {
    public static void reduceMath(Collection<PrgFunction> collection) {
        MathExprReduction mathExprReduction = new MathExprReduction();
        mathExprReduction.visitCollection(collection, null);
    }

    @Override
    protected void visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        super.visitAssignmentStmt(assignmentStmt, void_);
        for (int i = 0; i < assignmentStmt.getDestination().size(); ++i) {
            Assignable assignable = assignmentStmt.getDestination().get(i);
            if (!(assignable instanceof VariablePtrDeref)) continue;
            assignable = (Assignable)((Object)this.visitVariablePtrDeref((VariablePtrDeref)assignable, void_));
            assignmentStmt.getDestination().set(i, assignable);
        }
    }

    @Override
    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Void void_) {
        Expression expression = this.visitExpression(variablePtrDeref.getExpression(), void_);
        if (expression instanceof VariablePtrOf) {
            return ((VariablePtrOf)expression).getExpression();
        }
        variablePtrDeref.setExpression(expression);
        return variablePtrDeref;
    }

    @Override
    protected Expression visitIntegerExpr(IntegerExpr integerExpr, Void void_) {
        Expression expression;
        IntConstant intConstant;
        integerExpr = (IntegerExpr)super.visitIntegerExpr(integerExpr, void_);
        IntConstant intConstant2 = null;
        IntConstant intConstant3 = null;
        if (integerExpr.getLeft() instanceof IntConstant) {
            intConstant2 = (IntConstant)integerExpr.getLeft();
        }
        if (integerExpr.getRight() instanceof IntConstant) {
            intConstant3 = (IntConstant)integerExpr.getRight();
        }
        if (intConstant2 != null && intConstant3 != null) {
            return integerExpr;
        }
        if (intConstant2 == null && intConstant3 == null) {
            return integerExpr;
        }
        if (intConstant2 != null) {
            intConstant = intConstant2;
            expression = integerExpr.getRight();
        } else {
            intConstant = intConstant3;
            expression = integerExpr.getLeft();
        }
        switch (integerExpr.getOp()) {
            case Add: 
            case Xor: {
                switch ((int)intConstant.getValue()) {
                    case 0: {
                        return expression;
                    }
                }
                return integerExpr;
            }
            case And: {
                switch ((int)intConstant.getValue()) {
                    case 0: {
                        return new IntConstant(0L);
                    }
                }
                return integerExpr;
            }
            case Div: {
                switch ((int)intConstant.getValue()) {
                    case 1: {
                        return expression;
                    }
                }
                return integerExpr;
            }
            case Mul: {
                switch ((int)intConstant.getValue()) {
                    case 0: {
                        return new IntConstant(0L);
                    }
                    case 1: {
                        return expression;
                    }
                }
                return integerExpr;
            }
            case Or: 
            case Sub: 
            case ShiftArithmeticLeft: 
            case ShiftArithmeticRight: 
            case ShiftLeft: 
            case ShiftRight: {
                return integerExpr;
            }
        }
        throw new RuntimeException("Unhandled integer expression: " + (Object)((Object)integerExpr.getOp()));
    }
}

