/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Application;
import cfg.statement.Statement;
import java.util.List;
import knowledge.KnowFuncCall;
import knowledge.KnowMemAccess;
import knowledge.MemAccess;

public class MemoryModelEnforcer {
    private KnowMemAccess kma;
    private KnowFuncCall kfc;

    public MemoryModelEnforcer(Application application) {
        this.kma = (KnowMemAccess)application.getKb().getEntry(KnowMemAccess.class);
        this.kfc = (KnowFuncCall)application.getKb().getEntry(KnowFuncCall.class);
    }

    public boolean isMoveAllowed(List<Statement> list, Statement statement, Statement statement2) {
        assert (!statement.isDeleted());
        assert (!statement2.isDeleted());
        if (this.kfc.hasFuncCall(statement)) {
            return false;
        }
        if (this.kma.doesDynamicWrite(statement)) {
            return this.checkList(list, statement, statement2, false);
        }
        if (this.kma.doesDynamicRead(statement)) {
            return this.checkList(list, statement, statement2, true);
        }
        List<MemAccess> list2 = this.kma.getStaticReads(statement);
        List<MemAccess> list3 = this.kma.getStaticWrites(statement);
        if (list2.isEmpty() && list3.isEmpty()) {
            return true;
        }
        if (list3.isEmpty()) {
            return this.checkStaticReadList(list, statement, statement2, list2);
        }
        return this.checkList(list, statement, statement2, true);
    }

    private boolean checkStaticReadList(List<Statement> list, Statement statement, Statement statement2, List<MemAccess> list2) {
        for (int i = list.indexOf(statement) + 1; i < list.size(); ++i) {
            Statement statement3 = list.get(i);
            if (statement3 == statement2) {
                return true;
            }
            if (this.kma.doesDynamicWrite(statement3)) {
                return false;
            }
            List<MemAccess> list3 = this.kma.getStaticWrites(statement3);
            if (list3.isEmpty() || !MemAccess.mayOverlap(list2, list3)) continue;
            return false;
        }
        return false;
    }

    private boolean checkList(List<Statement> list, Statement statement, Statement statement2, boolean bl) {
        for (int i = list.indexOf(statement) + 1; i < list.size(); ++i) {
            Statement statement3 = list.get(i);
            if (statement3 == statement2) {
                return true;
            }
            if (this.kma.doesWrite(statement3)) {
                return false;
            }
            if (bl || !this.kma.doesRead(statement3)) continue;
            return false;
        }
        return false;
    }
}

