/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Assignable;
import cfg.IntConstant;
import cfg.IrItr;
import cfg.IrReplaceExprTraverser;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.function.PrgFunction;
import cfg.function.argument.FuncVariables;
import cfg.matcher.VarIntopConstMatcher;
import cfg.statement.AssignmentStmt;
import cfg.unlinker.HllVariable;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PtrArrayReplacer
extends IrReplaceExprTraverser<Void> {
    private final String locVarPrefix = "loc";
    private final int typesize = 4;
    private PrgFunction func = null;
    private Map<Long, Array> arrayMap = new HashMap<Long, Array>();

    public static void process(PrgFunction prgFunction, Set<Long> set) {
        PtrArrayReplacer ptrArrayReplacer = new PtrArrayReplacer(prgFunction, set);
        ptrArrayReplacer.visit(prgFunction, null);
    }

    public PtrArrayReplacer(PrgFunction prgFunction, Set<Long> set) {
        this.func = prgFunction;
        this.createArrayInfo(set);
    }

    private void createArrayInfo(Set<Long> set) {
        ArrayList<Long> arrayList = new ArrayList<Long>(set);
        Collections.sort(arrayList);
        if (!arrayList.isEmpty()) {
            assert (arrayList.get(arrayList.size() - 1) < (long)this.func.getStacksize());
            arrayList.add(Long.valueOf(this.func.getStacksize()));
            for (int i = 0; i < arrayList.size(); ++i) {
                long l = arrayList.get(i);
                assert (l % 4L == 0L);
                arrayList.set(i, l / 4L);
            }
            ArrayList<Long> arrayList2 = new ArrayList<Long>(arrayList.size() - 1);
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                long l = arrayList.get(i + 1) - arrayList.get(i);
                arrayList2.add(l);
            }
            arrayList.remove(arrayList.size() - 1);
            this.createLocalArrays(arrayList, arrayList2);
        }
    }

    private void createLocalArrays(ArrayList<Long> arrayList, ArrayList<Long> arrayList2) {
        assert (arrayList.size() == arrayList2.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            long l = arrayList.get(i);
            Array array = new Array(new HllVariable("loc" + l), l, arrayList2.get(i));
            this.arrayMap.put(l, array);
            this.func.addArray(array);
        }
    }

    @Override
    protected void visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        List<Assignable> list = assignmentStmt.getDestination();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getIrType() != IrType.VariablePtrDeref) continue;
            list.set(i, (Assignable)((Object)this.visitVariablePtrDeref((VariablePtrDeref)list.get(i), null)));
        }
        super.visitAssignmentStmt(assignmentStmt, null);
    }

    @Override
    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Void void_) {
        VarIntopConstMatcher varIntopConstMatcher = new VarIntopConstMatcher();
        varIntopConstMatcher.parse(new IrItr(variablePtrDeref.getExpression()));
        if (!varIntopConstMatcher.hasError() && varIntopConstMatcher.getVar() == FuncVariables.locPtr) {
            if (varIntopConstMatcher.getOp() != IntegerOp.Add) {
                throw new RuntimeException("Expect addition");
            }
            long l = varIntopConstMatcher.getValue();
            assert (l % 4L == 0L);
            Array array = this.arrayMap.get(l /= 4L);
            assert (array != null);
            ArrayAccess arrayAccess = new ArrayAccess(array, new IntConstant(0L));
            return arrayAccess;
        }
        return super.visitVariablePtrDeref(variablePtrDeref, void_);
    }

    @Override
    protected Expression visitIntegerExpr(IntegerExpr integerExpr, Void void_) {
        VarIntopConstMatcher varIntopConstMatcher = new VarIntopConstMatcher();
        varIntopConstMatcher.parse(new IrItr(integerExpr));
        if (!varIntopConstMatcher.hasError() && varIntopConstMatcher.getVar() == FuncVariables.locPtr) {
            if (varIntopConstMatcher.getOp() != IntegerOp.Add) {
                throw new RuntimeException("Expect addition");
            }
            long l = varIntopConstMatcher.getValue();
            assert (l % 4L == 0L);
            Array array = this.arrayMap.get(l /= 4L);
            assert (array != null);
            ArrayAccess arrayAccess = new ArrayAccess(array, new IntConstant(0L));
            return new VariablePtrOf(arrayAccess);
        }
        return super.visitIntegerExpr(integerExpr, void_);
    }
}

