/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.function.Function;
import cfg.function.PrgFunction;
import cfg.statement.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import knowledge.KnowDeletable;
import knowledge.KnowLinks;
import knowledge.KnowledgeBase;

public class StmtDeleter {
    private KnowLinks knowLinks;
    private KnowDeletable knowDeletable;
    private Set<Statement> visited = new HashSet<Statement>();

    public static int process(PrgFunction prgFunction, KnowledgeBase knowledgeBase) {
        StmtDeleter stmtDeleter = new StmtDeleter(knowledgeBase);
        return stmtDeleter.tuwas(prgFunction);
    }

    public static int process(Collection<? extends Function> collection, KnowledgeBase knowledgeBase) {
        int n = 0;
        for (Function function : collection) {
            if (function.getIrType() != IrType.FuncProgram) continue;
            n += StmtDeleter.process((PrgFunction)function, knowledgeBase);
        }
        return n;
    }

    public StmtDeleter(KnowledgeBase knowledgeBase) {
        this.knowLinks = (KnowLinks)knowledgeBase.getEntry(KnowLinks.class);
        this.knowDeletable = (KnowDeletable)knowledgeBase.getEntry(KnowDeletable.class);
    }

    private int tuwas(PrgFunction prgFunction) {
        this.keep(prgFunction);
        return this.remove(prgFunction);
    }

    private int remove(PrgFunction prgFunction) {
        int n = 0;
        for (BasicBlock basicBlock : prgFunction.getGraph().vertexSet()) {
            for (Statement statement : basicBlock.getCode()) {
                if (this.visited.contains(statement)) continue;
                if (!statement.isDeleted()) {
                    ++n;
                }
                statement.setDeleted();
            }
        }
        return n;
    }

    private void keep(PrgFunction prgFunction) {
        for (BasicBlock basicBlock : prgFunction.getGraph().vertexSet()) {
            for (Statement statement : basicBlock.getCode()) {
                if (statement.isDeleted() || this.knowDeletable.isDeletable(statement)) continue;
                this.keep(statement);
            }
        }
    }

    private void keep(Statement statement) {
        if (!this.visited.contains(statement)) {
            this.visited.add(statement);
            for (Statement statement2 : this.knowLinks.getLinks(statement)) {
                this.keep(statement2);
            }
        }
    }
}

