/*
 * Decompiled with CFR 0.152.
 */
package reduction;

import cfg.Application;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.function.PrgFunction;
import cfg.statement.PhiStmt;
import cfg.statement.Statement;
import java.util.HashSet;
import java.util.Set;
import knowledge.KnowReferencees;
import knowledge.KnowUnlinked;
import knowledge.KnowledgeBase;

public class UnlinkedPhiDeleter {
    private KnowReferencees kre;
    private KnowUnlinked kul;
    private Set<PhiStmt> removed = new HashSet<PhiStmt>();

    public static int process(PrgFunction prgFunction, KnowledgeBase knowledgeBase) {
        UnlinkedPhiDeleter unlinkedPhiDeleter = new UnlinkedPhiDeleter(knowledgeBase);
        return unlinkedPhiDeleter.tuwas(prgFunction);
    }

    public static int process(Application application) {
        int n = 0;
        for (PrgFunction prgFunction : application.getFunctions()) {
            if (prgFunction.getIrType() != IrType.FuncProgram) continue;
            n += UnlinkedPhiDeleter.process(prgFunction, application.getKb());
        }
        return n;
    }

    public UnlinkedPhiDeleter(KnowledgeBase knowledgeBase) {
        this.kre = (KnowReferencees)knowledgeBase.getEntry(KnowReferencees.class);
        this.kul = (KnowUnlinked)knowledgeBase.getEntry(KnowUnlinked.class);
    }

    private int tuwas(PrgFunction prgFunction) {
        this.keep(prgFunction);
        return this.remove(prgFunction);
    }

    private int remove(PrgFunction prgFunction) {
        for (PhiStmt phiStmt : this.removed) {
            phiStmt.setDeleted();
        }
        return this.removed.size();
    }

    private void keep(PrgFunction prgFunction) {
        for (BasicBlock basicBlock : prgFunction.getGraph().vertexSet()) {
            for (Statement statement : basicBlock.getCode()) {
                if (statement.isDeleted() || !(statement instanceof PhiStmt) || !this.kul.hasUnlinked(statement)) continue;
                this.remove(statement);
            }
        }
    }

    private void remove(Statement statement) {
        if (!(statement instanceof PhiStmt)) {
            throw new RuntimeException("Non-phi function depending on incomplete phi function: " + statement);
        }
        if (this.removed.contains(statement)) {
            return;
        }
        this.removed.add((PhiStmt)statement);
        Set<Statement> set = this.kre.getReferencees(((PhiStmt)statement).getVarname());
        for (Statement statement2 : set) {
            this.remove(statement2);
        }
    }
}

