/*
 * Decompiled with CFR 0.152.
 */
package structuring;

import ast.expression.BooleanConstant;
import ast.expression.IfExpr;
import ast.expression.IntConstant;
import ast.statement.AssignmentStmt;
import ast.statement.BlockStmt;
import ast.statement.CaseStmt;
import ast.statement.NullStmt;
import ast.statement.WhileStmt;
import ast.variable.VariableRefUnlinked;
import cfg.IrElement;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.FunctionGraph;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.Statement;
import graph.algorithm.FindEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import structuring.Merger;
import structuring.Translator;

public class Fallback {
    static final String switchvar = "_next";

    public static void fallback(FunctionGraph functionGraph, Map<BasicBlock, ast.statement.Statement> map) {
        Object object;
        IrElement irElement;
        Object object2;
        int n;
        HashMap<Integer, ast.statement.Statement> hashMap = new HashMap<Integer, ast.statement.Statement>();
        HashMap<Long, Integer> hashMap2 = new HashMap<Long, Integer>();
        Object object3 = new ArrayList<Long>(functionGraph.vertexSet().size());
        for (BasicBlock set2 : functionGraph.vertexSet()) {
            ((ArrayList)object3).add(set2.getId());
        }
        Collections.sort(object3);
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            BasicBlock basicBlock = functionGraph.getVertex((Long)((ArrayList)object3).get(n));
            hashMap2.put(basicBlock.getId(), n);
        }
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            BlockStmt blockStmt = new BlockStmt();
            hashMap.put(n, blockStmt);
            object2 = functionGraph.getVertex((Long)((ArrayList)object3).get(n));
            blockStmt.addCode(map.get(object2));
            irElement = ((BasicBlock)object2).getCode().getLast();
            if (!(irElement instanceof JumpStmt)) continue;
            object = Fallback.convertJmpToExpr((JumpStmt)irElement, hashMap2);
            blockStmt.addCode((ast.statement.Statement)object);
        }
        object3 = new BlockStmt();
        Set<BasicBlock> set3 = FindEntry.getEntry(functionGraph);
        AssignmentStmt assignmentStmt = new AssignmentStmt(new VariableRefUnlinked(switchvar), new IntConstant(((Integer)hashMap2.get(((BasicBlock)((Object)set3)).getId())).intValue()));
        ((BlockStmt)object3).addCode(assignmentStmt);
        set3 = new CaseStmt(new VariableRefUnlinked(switchvar), hashMap, new NullStmt());
        WhileStmt whileStmt = new WhileStmt(new BooleanConstant(true), (ast.statement.Statement)((Object)set3));
        ((BlockStmt)object3).addCode(whileStmt);
        set3 = functionGraph.vertexSet();
        Set<BbEdge> set = functionGraph.edgeSet();
        object2 = new ArrayList();
        object2.add(new NopStmt());
        irElement = new BasicBlock(0L);
        ((BasicBlock)irElement).setCode((List<Statement>)object2);
        object = new Merger(functionGraph);
        ((Merger)object).merge(set3, set, (BasicBlock)irElement);
        map.put((BasicBlock)irElement, (ast.statement.Statement)object3);
    }

    private static ast.statement.Statement convertJmpToExpr(JumpStmt jumpStmt, HashMap<Long, Integer> hashMap) {
        switch (jumpStmt.getJmpDst().size()) {
            case 0: {
                throw new RuntimeException("Jump needs at least one output");
            }
            case 1: {
                return new AssignmentStmt(new VariableRefUnlinked(switchvar), new IntConstant(hashMap.get(jumpStmt.getJmpDst().get(0)).intValue()));
            }
            case 2: {
                int n = hashMap.get(jumpStmt.getJmpDst().get(1));
                int n2 = hashMap.get(jumpStmt.getJmpDst().get(0));
                IfExpr ifExpr = new IfExpr(Translator.translate(jumpStmt.getExpression()), new IntConstant(n), new IntConstant(n2));
                return new AssignmentStmt(new VariableRefUnlinked(switchvar), ifExpr);
            }
        }
        HashMap<Integer, ast.statement.Statement> hashMap2 = new HashMap<Integer, ast.statement.Statement>(jumpStmt.getJmpDst().size());
        for (int i = 0; i < jumpStmt.getJmpDst().size(); ++i) {
            int n = hashMap.get(jumpStmt.getJmpDst().get(i));
            AssignmentStmt assignmentStmt = new AssignmentStmt(new VariableRefUnlinked(switchvar), new IntConstant(n));
            hashMap2.put(i, assignmentStmt);
        }
        return new CaseStmt(Translator.translate(jumpStmt.getExpression()), hashMap2, new NullStmt());
    }
}

