/*
 * Decompiled with CFR 0.152.
 */
package structuring;

import ast.PrgFunc;
import ast.statement.BlockStmt;
import ast.statement.VarDef;
import ast.type.Type;
import ast.variable.Variable;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.FuncProtParam;
import cfg.function.FunctionGraph;
import cfg.function.PrgFunction;
import cfg.statement.Statement;
import cfg.variable.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import structuring.Fallback;
import structuring.Merger;
import structuring.Translator;
import structuring.matcher.BusyWaitMatcher;
import structuring.matcher.CaseMatcher;
import structuring.matcher.CompositionMatcher;
import structuring.matcher.EndlessLoop;
import structuring.matcher.IfThenElseMatcher;
import structuring.matcher.IfThenMatcher;
import structuring.matcher.IfThenReturnMatcher;
import structuring.matcher.Pattern;
import structuring.matcher.ShortCircuitMatcher;
import structuring.matcher.WhileMatcher;
import util.NumPrint;
import util.StmtUtil;

public class Structurer {
    public static PrgFunc process(PrgFunction prgFunction) {
        PrgFunc prgFunc = new PrgFunc(Structurer.tuwas(prgFunction.getGraph(), prgFunction.getAddr()), "func" + NumPrint.toString(prgFunction.getAddr()), prgFunction.getReturnType());
        for (FuncProtParam object : prgFunction.getParam()) {
            Variable variable = new Variable(object.name, Type.Generic);
            prgFunc.getParam().add(variable);
        }
        BlockStmt blockStmt = new BlockStmt();
        for (Array array : prgFunction.getArrays()) {
            if (array.getSize() <= 1L) continue;
            VarDef varDef = new VarDef(new Variable(array.getName().toString(), Type.Pointer, (int)array.getSize()));
            blockStmt.addCode(varDef);
        }
        blockStmt.addCode(prgFunc.getBody());
        prgFunc.setBody(blockStmt);
        return prgFunc;
    }

    private static ast.statement.Statement tuwas(FunctionGraph functionGraph, long l) {
        HashMap<BasicBlock, ast.statement.Statement> hashMap = new HashMap<BasicBlock, ast.statement.Statement>();
        for (BasicBlock arrayList2 : functionGraph.vertexSet()) {
            List<Statement> list = arrayList2.getCode();
            assert (StmtUtil.getNrOfStmts(list) >= 1);
            BlockStmt blockStmt = Translator.translate(list);
            list = list.subList(0, list.size() - 1);
            for (Statement statement : list) {
                statement.setDeleted();
            }
            assert (blockStmt != null);
            hashMap.put(arrayList2, blockStmt);
        }
        Merger merger = new Merger(functionGraph);
        while (functionGraph.vertexSet().size() > 1) {
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
            arrayList.add(new ShortCircuitMatcher());
            if (Structurer.reduce(arrayList, functionGraph, merger, hashMap)) continue;
            break;
        }
        while (functionGraph.vertexSet().size() > 1) {
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
            arrayList.add(new BusyWaitMatcher());
            arrayList.add(new EndlessLoop());
            arrayList.add(new CompositionMatcher());
            if (Structurer.reduce(arrayList, functionGraph, merger, hashMap)) continue;
            break;
        }
        while (functionGraph.vertexSet().size() > 1) {
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
            arrayList.add(new BusyWaitMatcher());
            arrayList.add(new WhileMatcher());
            arrayList.add(new IfThenReturnMatcher());
            arrayList.add(new IfThenMatcher());
            arrayList.add(new IfThenElseMatcher());
            arrayList.add(new EndlessLoop());
            arrayList.add(new CompositionMatcher());
            arrayList.add(new CaseMatcher());
            if (Structurer.reduce(arrayList, functionGraph, merger, hashMap)) continue;
            break;
        }
        if (functionGraph.vertexSet().size() > 1) {
            Fallback.fallback(functionGraph, hashMap);
        }
        assert (functionGraph.vertexSet().size() == 1);
        return (ast.statement.Statement)hashMap.get(functionGraph.vertexSet().iterator().next());
    }

    private static boolean reduce(List<Pattern> list, DirectedGraph<BasicBlock, BbEdge> directedGraph, Merger merger, Map<BasicBlock, ast.statement.Statement> map) {
        for (Pattern pattern : list) {
            for (BasicBlock basicBlock : directedGraph.vertexSet()) {
                if (!pattern.match(basicBlock)) continue;
                ArrayList<BasicBlock> arrayList = pattern.vertices().get(0);
                ArrayList<BbEdge> arrayList2 = pattern.edges().get(0);
                List<BasicBlock> list2 = arrayList.subList(0, pattern.internalVertices());
                assert (arrayList2.size() >= pattern.internalEdges());
                List<BbEdge> list3 = arrayList2.subList(0, pattern.internalEdges());
                ast.statement.Statement statement = pattern.getStmtCode(arrayList, map);
                BasicBlock basicBlock2 = new BasicBlock(list2.get(0).getId());
                basicBlock2.addCode(pattern.getNewJump(arrayList));
                merger.merge(list2, list3, basicBlock2);
                map.put(basicBlock2, statement);
                return true;
            }
        }
        return false;
    }
}

