/*
 * Decompiled with CFR 0.152.
 */
package structuring;

import ast.Ast;
import ast.expression.ArithmeticExpr;
import ast.expression.CallExpr;
import ast.expression.CompareOp;
import ast.expression.Expression;
import ast.expression.FunctionRefUnlinked;
import ast.expression.IfExpr;
import ast.expression.IntegerOp;
import ast.expression.NullExpr;
import ast.expression.StringConstant;
import ast.expression.UnaryOp;
import ast.statement.BlockStmt;
import ast.statement.CallStmt;
import ast.statement.RetStmt;
import cfg.BooleanConstant;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.IrTraverser;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.CompareExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.UnaryExpression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.SysFunction;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.PhiStmt;
import cfg.statement.Statement;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.SsaVariable;
import cfg.variable.StackVariable;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Translator
extends IrTraverser<Ast, Void> {
    public static BlockStmt translate(List<Statement> list) {
        Translator translator = new Translator();
        BlockStmt blockStmt = (BlockStmt)translator.visit(list, null);
        assert (blockStmt != null);
        return blockStmt;
    }

    public static Expression translate(cfg.expression.Expression expression) {
        Translator translator = new Translator();
        Expression expression2 = (Expression)translator.visit(expression, null);
        assert (expression2 != null);
        return expression2;
    }

    private Ast visit(Object object) {
        return (Ast)this.visit(object, null);
    }

    @Override
    protected Ast visitBbEdge(BbEdge bbEdge, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitSsaVariable(SsaVariable ssaVariable, Void void_) {
        return new ast.variable.VariableRefUnlinked(ssaVariable.getName().toString());
    }

    @Override
    protected Ast visitArray(Array array, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitFunction(Function function, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitSysFunction(SysFunction sysFunction, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitPrgFunction(PrgFunction prgFunction, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitLibFunction(LibFunction libFunction, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitBasicBlock(BasicBlock basicBlock, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitCollection(Collection<IrElement> collection, Void void_) {
        BlockStmt blockStmt = new BlockStmt();
        for (IrElement irElement : collection) {
            assert (irElement instanceof Statement);
            if (((Statement)irElement).isDeleted() || irElement instanceof JumpStmt) continue;
            ast.statement.Statement statement = (ast.statement.Statement)this.visit(irElement);
            assert (statement != null);
            blockStmt.addCode(statement);
        }
        return blockStmt;
    }

    @Override
    protected Ast visitCallExprLinked(CallExprLinked callExprLinked, Void void_) {
        long l = callExprLinked.getFunc() instanceof PrgFunction ? ((PrgFunction)callExprLinked.getFunc()).getAddr() : (long)(-callExprLinked.getFunc().hashCode());
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (cfg.expression.Expression expression : callExprLinked.getParam()) {
            arrayList.add((Expression)this.visit(expression));
        }
        CallExpr callExpr = new CallExpr(new FunctionRefUnlinked(l, callExprLinked.getFunc().toString()), arrayList);
        return callExpr;
    }

    @Override
    protected Ast visitCallExprUnlinked(CallExprUnlinked callExprUnlinked, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitCallExprPointer(CallExprPointer callExprPointer, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitUnaryExpression(UnaryExpression unaryExpression, Void void_) {
        UnaryOp unaryOp;
        switch (unaryExpression.getOp()) {
            case Neg: {
                unaryOp = UnaryOp.Neg;
                break;
            }
            case Not: {
                unaryOp = UnaryOp.Not;
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator: " + (Object)((Object)unaryExpression.getOp()));
            }
        }
        return new ast.expression.UnaryExpression((Expression)this.visit(unaryExpression.getExpr()), unaryOp);
    }

    @Override
    protected Ast visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, Void void_) {
        return new ast.variable.VariableRefUnlinked(variableRefUnlinked.getName().toString());
    }

    @Override
    protected Ast visitVariableRefLinked(VariableRefLinked variableRefLinked, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitVariableKilled(VariableKilled variableKilled, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitBooleanConstant(BooleanConstant booleanConstant, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitConstant(IntConstant intConstant, Void void_) {
        long l = intConstant.getValue();
        if (l > Integer.MAX_VALUE) {
            l -= 0x100000000L;
        }
        assert (l <= Integer.MAX_VALUE);
        assert (l >= Integer.MIN_VALUE);
        return new ast.expression.IntConstant(l);
    }

    @Override
    protected Ast visitStringConstant(cfg.StringConstant stringConstant, Void void_) {
        return new StringConstant(stringConstant.getContent());
    }

    @Override
    protected Ast visitVariablePtrOf(VariablePtrOf variablePtrOf, Void void_) {
        return new ast.expression.VariablePtrOf((ast.variable.ArrayAccess)this.visit(variablePtrOf.getExpression()));
    }

    @Override
    protected Ast visitVariableArrayAccess(ArrayAccess arrayAccess, Void void_) {
        return new ast.variable.ArrayAccess(new ast.variable.VariableRefUnlinked(arrayAccess.getBase().toString()), (Expression)this.visit(arrayAccess.getIndex()));
    }

    @Override
    protected Ast visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Void void_) {
        return new ast.expression.VariablePtrDeref((Expression)this.visit(variablePtrDeref.getExpression()));
    }

    @Override
    protected Ast visitStackVariable(StackVariable stackVariable, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitGlobalVariable(GlobalVariable globalVariable, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitIfExpr(cfg.expression.IfExpr ifExpr, Void void_) {
        return new IfExpr((Expression)this.visit(ifExpr.getCondition()), (Expression)this.visit(ifExpr.getLeft()), (Expression)this.visit(ifExpr.getRight()));
    }

    @Override
    protected Ast visitIntegerExpr(IntegerExpr integerExpr, Void void_) {
        IntegerOp integerOp;
        switch (integerExpr.getOp()) {
            case Add: {
                integerOp = IntegerOp.Add;
                break;
            }
            case And: {
                integerOp = IntegerOp.And;
                break;
            }
            case Div: {
                integerOp = IntegerOp.Div;
                break;
            }
            case Mul: {
                integerOp = IntegerOp.Mul;
                break;
            }
            case Or: {
                integerOp = IntegerOp.Or;
                break;
            }
            case ShiftArithmeticLeft: 
            case ShiftLeft: {
                integerOp = IntegerOp.ShiftLeft;
                break;
            }
            case ShiftArithmeticRight: 
            case ShiftRight: {
                integerOp = IntegerOp.ShiftRight;
                break;
            }
            case Sub: {
                integerOp = IntegerOp.Sub;
                break;
            }
            case Xor: {
                integerOp = IntegerOp.Xor;
                break;
            }
            default: {
                throw new RuntimeException("Not handled operand: " + (Object)((Object)integerExpr.getOp()));
            }
        }
        return new ArithmeticExpr((Expression)this.visit(integerExpr.getLeft()), (Expression)this.visit(integerExpr.getRight()), integerOp);
    }

    @Override
    protected Ast visitCompareExpr(CompareExpr compareExpr, Void void_) {
        CompareOp compareOp;
        switch (compareExpr.getOperand()) {
            case EQUAL: {
                compareOp = CompareOp.EQUAL;
                break;
            }
            case GREATER: {
                compareOp = CompareOp.GREATER;
                break;
            }
            case GREATER_EQUAL: {
                compareOp = CompareOp.GREATER_EQUAL;
                break;
            }
            case LOWER: {
                compareOp = CompareOp.LOWER;
                break;
            }
            case LOWER_EQUAL: {
                compareOp = CompareOp.LOWER_EQUAL;
                break;
            }
            case NOT_EQUAL: {
                compareOp = CompareOp.NOT_EQUAL;
                break;
            }
            default: {
                throw new RuntimeException("Not handled operand: " + (Object)((Object)compareExpr.getOperand()));
            }
        }
        return new ast.expression.CompareExpr((Expression)this.visit(compareExpr.getLeft()), (Expression)this.visit(compareExpr.getRight()), compareOp);
    }

    @Override
    protected Ast visitPhiStmt(PhiStmt phiStmt, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitRetStmt(cfg.statement.RetStmt retStmt, Void void_) {
        Expression expression;
        if (retStmt.getRetval().size() == 1) {
            expression = (Expression)this.visit(retStmt.getRetval().values().iterator().next());
        } else {
            assert (retStmt.getRetval().size() == 0);
            expression = new NullExpr();
        }
        return new RetStmt(expression);
    }

    @Override
    protected Ast visitJumpStmt(JumpStmt jumpStmt, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitNopStmt(NopStmt nopStmt, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Ast visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        switch (assignmentStmt.getDestination().size()) {
            case 0: {
                return new CallStmt((CallExpr)this.visit(assignmentStmt.getSource()));
            }
            case 1: {
                return new ast.statement.AssignmentStmt((Expression)this.visit(assignmentStmt.getDestination().get(0)), (Expression)this.visit(assignmentStmt.getSource()));
            }
        }
        throw new RuntimeException("Not yet implemented");
    }
}

