/*
 * Decompiled with CFR 0.152.
 */
package structuring.matcher;

import ast.expression.Expression;
import ast.expression.UnaryExpression;
import ast.expression.UnaryOp;
import ast.statement.DoWhile;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import structuring.Translator;
import structuring.matcher.Pattern;
import util.Combinations;
import util.StmtUtil;

public class BusyWaitMatcher
implements Pattern {
    private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList();
    private ArrayList<ArrayList<BbEdge>> edges = new ArrayList();

    @Override
    public ArrayList<ArrayList<BbEdge>> edges() {
        return this.edges;
    }

    @Override
    public int internalEdges() {
        return 1;
    }

    @Override
    public ArrayList<ArrayList<BasicBlock>> vertices() {
        return this.vertices;
    }

    @Override
    public int internalVertices() {
        return 1;
    }

    @Override
    public boolean match(BasicBlock basicBlock) {
        if (basicBlock.getOutlist().size() != 2) {
            return false;
        }
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(basicBlock.getOutlist());
        Combinations combinations = new Combinations(2, arrayList.size());
        while (combinations.hasNext()) {
            Object object = combinations.next();
            BbEdge bbEdge = arrayList.get((Integer)((ArrayList)object).get(0));
            BasicBlock basicBlock2 = (BasicBlock)bbEdge.getDst();
            BasicBlock basicBlock3 = (BasicBlock)arrayList.get((Integer)((ArrayList)object).get(1)).getDst();
            if (basicBlock != basicBlock2) continue;
            this.addToVerices(basicBlock, basicBlock3);
            this.addToEdges(bbEdge);
        }
        return !this.vertices.isEmpty();
    }

    private void addToVerices(BasicBlock basicBlock, BasicBlock basicBlock2) {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>(2);
        arrayList.add(basicBlock);
        arrayList.add(basicBlock2);
        this.vertices.add(arrayList);
    }

    private void addToEdges(BbEdge bbEdge) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(1);
        arrayList.add(bbEdge);
        this.edges.add(arrayList);
    }

    @Override
    public JumpStmt getNewJump(ArrayList<BasicBlock> arrayList) {
        return new JumpStmt(arrayList.get(1).getId());
    }

    @Override
    public ast.statement.Statement getStmtCode(ArrayList<BasicBlock> arrayList, Map<BasicBlock, ast.statement.Statement> map) {
        assert (this.vertices.contains(arrayList));
        LinkedList<Statement> linkedList = arrayList.get(0).getCode();
        assert (StmtUtil.getNrOfStmts(linkedList) == 1);
        Expression expression = Translator.translate(StmtUtil.toJump(linkedList.getLast()).getExpression());
        if (this.isInverted(arrayList)) {
            expression = new UnaryExpression(expression, UnaryOp.Not);
        }
        ast.statement.Statement statement = map.get(arrayList.get(0));
        return new DoWhile(statement, expression);
    }

    private boolean isInverted(ArrayList<BasicBlock> arrayList) {
        BbEdge bbEdge;
        BasicBlock basicBlock = arrayList.get(0);
        ArrayList<BbEdge> arrayList2 = new ArrayList<BbEdge>(basicBlock.getInlist());
        assert (arrayList2.size() == 2);
        if (arrayList2.get(0).getSrc() == basicBlock) {
            bbEdge = arrayList2.get(0);
        } else {
            assert (arrayList2.get(1).getSrc() == basicBlock);
            bbEdge = arrayList2.get(1);
        }
        assert (bbEdge.getSrc() == basicBlock);
        assert (bbEdge.getDst() == basicBlock);
        return bbEdge.getNr() == 0;
    }
}

