/*
 * Decompiled with CFR 0.152.
 */
package structuring.matcher;

import ast.expression.Expression;
import ast.statement.BlockStmt;
import ast.statement.CaseStmt;
import ast.statement.NullStmt;
import ast.statement.Statement;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import structuring.Translator;
import structuring.matcher.Pattern;
import util.StmtUtil;

public class CaseMatcher
implements Pattern {
    private ArrayList<BasicBlock> vertices = new ArrayList();
    private ArrayList<BbEdge> outedges = new ArrayList();
    private ArrayList<BbEdge> joinedges = new ArrayList();

    @Override
    public ArrayList<ArrayList<BbEdge>> edges() {
        ArrayList<ArrayList<BbEdge>> arrayList = new ArrayList<ArrayList<BbEdge>>();
        ArrayList<BbEdge> arrayList2 = new ArrayList<BbEdge>();
        arrayList2.addAll(this.outedges);
        arrayList2.addAll(this.joinedges);
        arrayList.add(arrayList2);
        return arrayList;
    }

    @Override
    public int internalEdges() {
        return this.outedges.size() + this.joinedges.size() - 1;
    }

    @Override
    public ArrayList<ArrayList<BasicBlock>> vertices() {
        ArrayList<ArrayList<BasicBlock>> arrayList = new ArrayList<ArrayList<BasicBlock>>();
        arrayList.add(this.vertices);
        return arrayList;
    }

    @Override
    public int internalVertices() {
        return this.vertices.size() - 1;
    }

    @Override
    public boolean match(BasicBlock basicBlock) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(basicBlock.getOutlist());
        if (arrayList.size() <= 2) {
            return false;
        }
        ArrayList<BasicBlock> arrayList2 = new ArrayList<BasicBlock>(arrayList.size());
        ArrayList<BbEdge> arrayList3 = new ArrayList<BbEdge>(arrayList.size());
        BasicBlock basicBlock2 = null;
        for (BbEdge bbEdge : arrayList) {
            BasicBlock basicBlock3 = (BasicBlock)bbEdge.getDst();
            if (basicBlock3.getOutlist().size() >= 2) {
                return false;
            }
            arrayList2.add(basicBlock3);
            BbEdge bbEdge2 = basicBlock3.getOutlist().iterator().next();
            arrayList3.add(bbEdge2);
            if (basicBlock2 == null) {
                basicBlock2 = (BasicBlock)bbEdge2.getDst();
                continue;
            }
            if (basicBlock2 == bbEdge2.getDst()) continue;
            return false;
        }
        this.addToVertices(basicBlock, basicBlock2, arrayList2);
        this.outedges = arrayList;
        this.joinedges = arrayList3;
        return true;
    }

    private void addToVertices(BasicBlock basicBlock, BasicBlock basicBlock2, ArrayList<BasicBlock> arrayList) {
        this.vertices = new ArrayList(2 + arrayList.size());
        this.vertices.add(basicBlock);
        this.vertices.addAll(arrayList);
        this.vertices.add(basicBlock2);
    }

    @Override
    public JumpStmt getNewJump(ArrayList<BasicBlock> arrayList) {
        return new JumpStmt(arrayList.get(arrayList.size() - 1).getId());
    }

    @Override
    public Statement getStmtCode(ArrayList<BasicBlock> arrayList, Map<BasicBlock, Statement> map) {
        assert (this.vertices == arrayList);
        Expression expression = Translator.translate(StmtUtil.toJump(this.vertices.get(0).getCode().getLast()).getExpression());
        BlockStmt blockStmt = new BlockStmt();
        HashMap<Integer, Statement> hashMap = new HashMap<Integer, Statement>();
        for (int i = 1; i < this.vertices.size() - 1; ++i) {
            hashMap.put(i - 1, map.get(this.vertices.get(i)));
        }
        CaseStmt caseStmt = new CaseStmt(expression, hashMap, new NullStmt());
        blockStmt.addCode(map.get(this.vertices.get(0)));
        blockStmt.addCode(caseStmt);
        return blockStmt;
    }
}

