/*
 * Decompiled with CFR 0.152.
 */
package structuring.matcher;

import ast.statement.BlockStmt;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.Statement;
import java.util.ArrayList;
import java.util.Map;
import structuring.matcher.Pattern;
import util.StmtUtil;

public class CompositionMatcher
implements Pattern {
    private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList();
    private ArrayList<ArrayList<BbEdge>> BbEdges = new ArrayList();

    @Override
    public ArrayList<ArrayList<BbEdge>> edges() {
        return this.BbEdges;
    }

    @Override
    public int internalEdges() {
        return 1;
    }

    @Override
    public ArrayList<ArrayList<BasicBlock>> vertices() {
        return this.vertices;
    }

    @Override
    public int internalVertices() {
        return 2;
    }

    @Override
    public boolean match(BasicBlock basicBlock) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(basicBlock.getOutlist());
        if (arrayList.size() != 1) {
            return false;
        }
        BbEdge bbEdge = arrayList.get(0);
        BasicBlock basicBlock2 = (BasicBlock)bbEdge.getDst();
        if (basicBlock == basicBlock2) {
            return false;
        }
        if (basicBlock2.getInlist().size() != 1) {
            return false;
        }
        this.addToBbEdges(bbEdge);
        this.addToVertices(basicBlock, basicBlock2);
        return !this.vertices.isEmpty();
    }

    private void addToVertices(BasicBlock basicBlock, BasicBlock basicBlock2) {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>(2);
        arrayList.add(basicBlock);
        arrayList.add(basicBlock2);
        this.vertices.add(arrayList);
    }

    private void addToBbEdges(BbEdge bbEdge) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(1);
        arrayList.add(bbEdge);
        this.BbEdges.add(arrayList);
    }

    @Override
    public Statement getNewJump(ArrayList<BasicBlock> arrayList) {
        Statement statement = arrayList.get(1).getCode().getLast();
        if (statement instanceof JumpStmt) {
            return statement;
        }
        return new NopStmt();
    }

    @Override
    public ast.statement.Statement getStmtCode(ArrayList<BasicBlock> arrayList, Map<BasicBlock, ast.statement.Statement> map) {
        assert (this.vertices.contains(arrayList));
        assert (StmtUtil.getNrOfStmts(arrayList.get(0).getCode()) == 1);
        assert (StmtUtil.getNrOfStmts(arrayList.get(1).getCode()) <= 1);
        BlockStmt blockStmt = new BlockStmt();
        blockStmt.addCode(map.get(arrayList.get(0)));
        blockStmt.addCode(map.get(arrayList.get(1)));
        return blockStmt;
    }
}

