/*
 * Decompiled with CFR 0.152.
 */
package structuring.matcher;

import ast.expression.BooleanConstant;
import ast.statement.WhileStmt;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.NopStmt;
import cfg.statement.Statement;
import java.util.ArrayList;
import java.util.Map;
import structuring.matcher.Pattern;

public class EndlessLoop
implements Pattern {
    private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList();
    private ArrayList<ArrayList<BbEdge>> edges = new ArrayList();

    @Override
    public ArrayList<ArrayList<BbEdge>> edges() {
        return this.edges;
    }

    @Override
    public int internalEdges() {
        return 1;
    }

    @Override
    public ArrayList<ArrayList<BasicBlock>> vertices() {
        return this.vertices;
    }

    @Override
    public int internalVertices() {
        return 1;
    }

    @Override
    public boolean match(BasicBlock basicBlock) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(basicBlock.getOutlist());
        if (arrayList.size() != 1) {
            return false;
        }
        BbEdge bbEdge = arrayList.get(0);
        BasicBlock basicBlock2 = (BasicBlock)bbEdge.getDst();
        if (basicBlock2 != basicBlock) {
            return false;
        }
        this.addToVertices(basicBlock);
        this.addToEdges(bbEdge);
        return true;
    }

    private void addToVertices(BasicBlock basicBlock) {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>(1);
        arrayList.add(basicBlock);
        this.vertices.add(arrayList);
    }

    private void addToEdges(BbEdge bbEdge) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(1);
        arrayList.add(bbEdge);
        this.edges.add(arrayList);
    }

    @Override
    public Statement getNewJump(ArrayList<BasicBlock> arrayList) {
        return new NopStmt();
    }

    @Override
    public ast.statement.Statement getStmtCode(ArrayList<BasicBlock> arrayList, Map<BasicBlock, ast.statement.Statement> map) {
        assert (this.vertices.contains(arrayList));
        return new WhileStmt(new BooleanConstant(true), map.get(arrayList.get(0)));
    }
}

