/*
 * Decompiled with CFR 0.152.
 */
package structuring.matcher;

import ast.expression.Expression;
import ast.expression.UnaryExpression;
import ast.expression.UnaryOp;
import ast.statement.BlockStmt;
import ast.statement.IfStmt;
import ast.statement.Statement;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import java.util.ArrayList;
import java.util.Map;
import structuring.Translator;
import structuring.matcher.Pattern;
import util.Combinations;
import util.StmtUtil;

public class IfThenReturnMatcher
implements Pattern {
    private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList();
    private ArrayList<ArrayList<BbEdge>> edges = new ArrayList();

    @Override
    public ArrayList<ArrayList<BbEdge>> edges() {
        return this.edges;
    }

    @Override
    public int internalEdges() {
        return 1;
    }

    @Override
    public ArrayList<ArrayList<BasicBlock>> vertices() {
        return this.vertices;
    }

    @Override
    public int internalVertices() {
        return 2;
    }

    @Override
    public boolean match(BasicBlock basicBlock) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(basicBlock.getOutlist());
        if (arrayList.size() != 2) {
            return false;
        }
        Combinations combinations = new Combinations(2, arrayList.size());
        while (combinations.hasNext()) {
            Object object = combinations.next();
            BbEdge bbEdge = arrayList.get((Integer)((ArrayList)object).get(1));
            BasicBlock basicBlock2 = (BasicBlock)arrayList.get((Integer)((ArrayList)object).get(0)).getDst();
            BasicBlock basicBlock3 = (BasicBlock)bbEdge.getDst();
            if (basicBlock3 == basicBlock || basicBlock3.getOutlist().size() != 0 || basicBlock3.getInlist().size() != 1) continue;
            this.addToVerices(basicBlock, basicBlock3, basicBlock2);
            this.addToEdges(bbEdge);
        }
        return !this.vertices.isEmpty();
    }

    private void addToVerices(BasicBlock basicBlock, BasicBlock basicBlock2, BasicBlock basicBlock3) {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>(3);
        arrayList.add(basicBlock);
        arrayList.add(basicBlock2);
        arrayList.add(basicBlock3);
        this.vertices.add(arrayList);
    }

    private void addToEdges(BbEdge bbEdge) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(1);
        arrayList.add(bbEdge);
        this.edges.add(arrayList);
    }

    @Override
    public JumpStmt getNewJump(ArrayList<BasicBlock> arrayList) {
        return new JumpStmt(arrayList.get(2).getId());
    }

    @Override
    public Statement getStmtCode(ArrayList<BasicBlock> arrayList, Map<BasicBlock, Statement> map) {
        assert (this.vertices.contains(arrayList));
        Expression expression = Translator.translate(StmtUtil.toJump(arrayList.get(0).getCode().getLast()).getExpression());
        if (this.isInverted(arrayList)) {
            expression = new UnaryExpression(expression, UnaryOp.Not);
        }
        BlockStmt blockStmt = new BlockStmt();
        IfStmt ifStmt = new IfStmt(expression, map.get(arrayList.get(1)));
        blockStmt.addCode(map.get(arrayList.get(0)));
        blockStmt.addCode(ifStmt);
        return blockStmt;
    }

    private boolean isInverted(ArrayList<BasicBlock> arrayList) {
        return StmtUtil.getEdgeValue(arrayList.get(0), arrayList.get(1)) == 0;
    }
}

