/*
 * Decompiled with CFR 0.152.
 */
package structuring.matcher;

import ast.expression.Expression;
import ast.expression.UnaryExpression;
import ast.expression.UnaryOp;
import ast.statement.BlockStmt;
import ast.statement.WhileStmt;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import structuring.Translator;
import structuring.matcher.Pattern;
import util.Combinations;
import util.StmtUtil;

public class WhileMatcher
implements Pattern {
    private ArrayList<ArrayList<BasicBlock>> vertices = new ArrayList();
    private ArrayList<ArrayList<BbEdge>> edges = new ArrayList();

    @Override
    public ArrayList<ArrayList<BbEdge>> edges() {
        return this.edges;
    }

    @Override
    public int internalEdges() {
        return 2;
    }

    @Override
    public ArrayList<ArrayList<BasicBlock>> vertices() {
        return this.vertices;
    }

    @Override
    public int internalVertices() {
        return 2;
    }

    @Override
    public boolean match(BasicBlock basicBlock) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(basicBlock.getOutlist());
        if (arrayList.size() != 2) {
            return false;
        }
        Combinations combinations = new Combinations(2, arrayList.size());
        while (combinations.hasNext()) {
            Object object = combinations.next();
            BbEdge bbEdge = arrayList.get((Integer)((ArrayList)object).get(0));
            BasicBlock basicBlock2 = (BasicBlock)bbEdge.getDst();
            BasicBlock basicBlock3 = (BasicBlock)arrayList.get((Integer)((ArrayList)object).get(1)).getDst();
            if (basicBlock == basicBlock2 || basicBlock2.getInlist().size() != 1 || basicBlock2.getOutlist().size() != 1) continue;
            ArrayList<BbEdge> arrayList2 = new ArrayList<BbEdge>(basicBlock2.getOutlist());
            Combinations combinations2 = new Combinations(1, arrayList2.size());
            while (combinations2.hasNext()) {
                Object object2 = combinations2.next();
                BbEdge bbEdge2 = arrayList2.get((Integer)((ArrayList)object2).get(0));
                BasicBlock basicBlock4 = (BasicBlock)bbEdge2.getDst();
                if (basicBlock != basicBlock4) continue;
                this.addToVertices(basicBlock, basicBlock2, basicBlock3);
                this.addToEdges(bbEdge, bbEdge2);
            }
        }
        return !this.vertices.isEmpty();
    }

    private void addToVertices(BasicBlock basicBlock, BasicBlock basicBlock2, BasicBlock basicBlock3) {
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>(3);
        arrayList.add(basicBlock);
        arrayList.add(basicBlock2);
        arrayList.add(basicBlock3);
        this.vertices.add(arrayList);
    }

    private void addToEdges(BbEdge bbEdge, BbEdge bbEdge2) {
        ArrayList<BbEdge> arrayList = new ArrayList<BbEdge>(2);
        arrayList.add(bbEdge);
        arrayList.add(bbEdge2);
        this.edges.add(arrayList);
    }

    @Override
    public JumpStmt getNewJump(ArrayList<BasicBlock> arrayList) {
        return new JumpStmt(arrayList.get(2).getId());
    }

    @Override
    public ast.statement.Statement getStmtCode(ArrayList<BasicBlock> arrayList, Map<BasicBlock, ast.statement.Statement> map) {
        assert (this.vertices.contains(arrayList));
        LinkedList<Statement> linkedList = arrayList.get(0).getCode();
        assert (StmtUtil.getNrOfStmts(linkedList) == 1);
        Expression expression = Translator.translate(StmtUtil.toJump(linkedList.getLast()).getExpression());
        if (!this.isInverted(arrayList)) {
            expression = new UnaryExpression(expression, UnaryOp.Not);
        }
        assert (arrayList.get(1).getCode().getLast() instanceof JumpStmt);
        BlockStmt blockStmt = new BlockStmt();
        blockStmt.addCode(map.get(arrayList.get(1)));
        blockStmt.addCode(map.get(arrayList.get(0)));
        BlockStmt blockStmt2 = new BlockStmt();
        blockStmt2.addCode(map.get(arrayList.get(0)));
        blockStmt2.addCode(new WhileStmt(expression, blockStmt));
        return blockStmt2;
    }

    private boolean isInverted(ArrayList<BasicBlock> arrayList) {
        return StmtUtil.getEdgeValue(arrayList.get(0), arrayList.get(1)) == 1;
    }
}

