/*
 * Decompiled with CFR 0.152.
 */
package util;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;
import java.util.List;

public class StmtUtil {
    public static JumpStmt toJump(Statement statement) {
        if (statement.isDeleted()) {
            throw new RuntimeException("Basic block contains no statements");
        }
        if (!(statement instanceof JumpStmt)) {
            throw new RuntimeException("Basic block contains no jump");
        }
        return (JumpStmt)statement;
    }

    public static int getNrOfStmts(List<Statement> list) {
        int n = 0;
        for (Statement statement : list) {
            if (statement.isDeleted()) continue;
            ++n;
        }
        return n;
    }

    public static int getEdgeValue(BasicBlock basicBlock, BasicBlock basicBlock2) {
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            if (bbEdge.getDst() != basicBlock2) continue;
            return bbEdge.getNr();
        }
        throw new RuntimeException("No edge found");
    }
}

