
/*
 * dumsim.cpp
 *
 *  Created on: 23.04.2009
 *      Author: urs
 */

#include  <cmath>
#include  <argp.h>
#include <fstream>
#include <iostream>
#include  "../../src/common/paramutils.h"

using namespace std;

#include <argp.h>

const char *argp_program_version =      "Dummy simulator Version 0.1";
const char *argp_program_bug_address =  "<nobug@thisapp.unv>";

/* Program documentation. */
static char doc[] =     "Dummy simulator, gives a (deterministic) fitness value";

#define     SWITCH_INPUT      'i'
#define     SWITCH_OUTPUT     'o'

/* The options we understand. */
static struct argp_option options[] =
{
  { "input",    SWITCH_INPUT,   "FILE", 0,  "file with parameters" },
  { "output",   SWITCH_OUTPUT,  "FILE", 0,  "file for results" },
  { 0 }
};

/* Used by main to communicate with parse_opt. */
struct arguments
{
  string   input;
  string   output;
};

/* Parse a single option. */
static error_t parse_opt (int key, char *arg, struct argp_state *state)
{
 /* Get the input argument from argp_parse, which we
    know is a pointer to our arguments structure. */
  struct arguments *arguments = (struct arguments*)state->input;

  switch (key)
  {
    case SWITCH_INPUT:
    {
      arguments->input = arg;
      break;
    }

    case SWITCH_OUTPUT:
    {
      arguments->output = arg;
      break;
    }

    case ARGP_KEY_END:
    {
      break;
    }

    default:
    {
      return ARGP_ERR_UNKNOWN;
    }
  }

  return 0;
}

/* Our argp parser. */
static struct argp argp = { options, parse_opt, 0, doc };

double runSimulation( const MapParameterToValueT& values )
{
  bool                                    negativ;
  double                                  result;
  MapParameterToValueT::const_iterator    itr;

  negativ = true;
  result  = 0;

  for( itr = values.begin(); itr != values.end(); itr++ )
  {
    if( negativ )
    {
      result  = result - itr->second;
    }
    else
    {
      result  = result + itr->second;
    }

    negativ = !( negativ );
  }

  return  result;
}



int main(int argc, char* argv[])
{
  struct arguments arguments;

  /* Default values. */
  arguments.input         = "-";
  arguments.output        = "-";

  /* Parse our arguments; every option seen by parse_opt will
     be reflected in arguments. */
  argp_parse (&argp, argc, argv, 0, 0, &arguments);

  MapParameterToValueT    values;
  double                  fitness;

  fstream   file;

  file.open( arguments.input.c_str(), ios::in );
  deserializeMap( values, file );
  file.close();

  fitness = runSimulation( values );

  file.open( arguments.output.c_str(), ios::out );
  file << "fitness " << fitness << endl;
  file << "nan " << NAN << endl;
  file.close();


  return 0;
}





