#include  <stdio.h>
#include  <math.h>
#include  <unistd.h>

typedef  double  Point[2];

const Point   RANGE   = { 100.0, 100.0 };
const Point   TOP     = {  57.0,  42.0 };
const double  SCALING = 2.0;

void parsePoint( FILE* file, Point* point )
{
  int     idx;
  float   val;
  char    cmp;

  while( !( feof( file ) ) )
  {
    fscanf( file, "%c %f\n", &cmp, &val );
    
    switch( cmp )
    {
      case 'x': (*point)[0] = val; break;
      case 'y': (*point)[1] = val; break;
    }
  }
}

double sqr( double val )
{
  return  val * val;
}

double calcFitness( Point point )
{
  int     idx;
  double  result;
  
  result  = 0.0;
  
  for( idx = 0; idx <= sizeof(point) / sizeof(point[0]); idx++ )
  {
    result   = result + sqr( fabs( point[idx] - TOP[idx] ) / RANGE[idx] );
  }

  result       = sqrt( result );
  result       = result * SCALING;
  result       = 1.0 - result;
  result       = result > 0.0 ? result : 0.0;     // Oh yes, dirty c
  
  return  result;
}

int main( int argc, char* argv[] )
{
  char*   filein;
  char*   fileout;
  FILE*   file;
  char    c;
  double  fitness;
  Point   point;

  c = '\0';
  
  do
  {
    c = getopt( argc, argv, "i:o:" );
    
    switch( c )
    {
      case 'i' : filein  = optarg; break;
      case 'o' : fileout = optarg; break;
    }
  } while( c != -1 );

  point[0]  = -1;
  point[1]  = -1;

  file      = fopen( filein, "r+" );
  parsePoint( file, &point );
  fclose( file );

  fitness    = calcFitness( point );

  file      = fopen( fileout, "w+" );
  fprintf( file, "%s %f\n", "fitness", fitness );
  fclose( file );
  
  return  0;
}

